/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.core.HttpProviderFactory;
import org.json.JSONObject;

class AGSecurityAuthenticationModuleRunner {
    private static final String TAG = AGSecurityAuthenticationModuleRunner.class.getSimpleName();
    private final Provider<HttpProvider> httpProviderFactory = new HttpProviderFactory();
    private final URL baseURL;
    private final String loginEndpoint;
    private final URL loginURL;
    private final String logoutEndpoint;
    private final URL logoutURL;
    private final String enrollEndpoint;
    private final URL enrollURL;

    public AGSecurityAuthenticationModuleRunner(URL baseURL, AuthenticationConfig config) {
        this.baseURL = baseURL;
        this.loginEndpoint = config.getLoginEndpoint();
        this.logoutEndpoint = config.getLogoutEndpoint();
        this.enrollEndpoint = config.getEnrollEndpoint();
        this.loginURL = this.appendToBaseURL(this.loginEndpoint);
        this.logoutURL = this.appendToBaseURL(this.logoutEndpoint);
        this.enrollURL = this.appendToBaseURL(this.enrollEndpoint);
    }

    public HeaderAndBody onEnroll(Map<String, String> userData) {
        HttpProvider provider = this.httpProviderFactory.get(this.enrollURL);
        String enrollData = new JSONObject(userData).toString();
        return provider.post(enrollData);
    }

    public HeaderAndBody onLogin(String username, String password) {
        HttpProvider provider = this.httpProviderFactory.get(this.loginURL);
        String loginData = this.buildLoginData(username, password);
        return provider.post(loginData);
    }

    public void onLogout() {
        HttpProvider provider = this.httpProviderFactory.get(this.logoutURL);
        provider.post("");
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public String getEnrollEndpoint() {
        return this.enrollEndpoint;
    }

    private URL appendToBaseURL(String endpoint) {
        try {
            return new URL(this.baseURL.toString() + endpoint);
        }
        catch (MalformedURLException ex) {
            String message = "Could not append " + endpoint + " to " + this.baseURL.toString();
            Log.e((String)TAG, (String)message, (Throwable)ex);
            throw new IllegalArgumentException(message, ex);
        }
    }

    private String buildLoginData(String username, String password) {
        JsonObject response = new JsonObject();
        response.addProperty("username", username);
        response.addProperty("password", password);
        return response.toString();
    }
}

