/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader;

import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authentication.impl.loader.AbstractAuthenticationLoader;
import org.jboss.aerogear.android.authentication.impl.loader.EnrollLoader;
import org.jboss.aerogear.android.authentication.impl.loader.LoaderAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.LoginLoader;
import org.jboss.aerogear.android.authentication.impl.loader.LogoutLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.pipeline.AbstractActivityCallback;
import org.jboss.aerogear.android.pipeline.AbstractFragmentCallback;

public class AuthenticationModuleAdapter
implements LoaderAuthenticationModule,
LoaderManager.LoaderCallbacks<HeaderAndBody> {
    private static final String TAG = AuthenticationModuleAdapter.class.getSimpleName();
    private final Context applicationContext;
    private final AuthenticationModule module;
    private final LoaderManager manager;
    private final Activity activity;
    private final Fragment fragment;
    private final String name;
    private final Handler handler;

    public AuthenticationModuleAdapter(Activity activity, AuthenticationModule module, String name) {
        this.module = module;
        this.manager = activity.getLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.activity = activity;
        this.fragment = null;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
    }

    public AuthenticationModuleAdapter(Fragment fragment, Context applicationContext, AuthenticationModule module, String name) {
        this.module = module;
        this.manager = fragment.getLoaderManager();
        this.applicationContext = applicationContext;
        this.activity = null;
        this.fragment = fragment;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
    }

    @Override
    public URL getBaseURL() {
        return this.module.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.module.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.module.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.module.getEnrollEndpoint();
    }

    @Override
    public void enroll(Map<String, String> userData, Callback<HeaderAndBody> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, userData, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS", new HashMap<String, String>(userData));
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)((Object)Methods.ENROLL));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void login(String username, String password, Callback<HeaderAndBody> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, username, password, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME", (Serializable)((Object)username));
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD", (Serializable)((Object)password));
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)((Object)Methods.LOGIN));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void logout(Callback<Void> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)((Object)Methods.LOGOUT));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public boolean isLoggedIn() {
        return this.module.isLoggedIn();
    }

    @Override
    public AuthorizationFields getAuthorizationFields() {
        return this.module.getAuthorizationFields();
    }

    public Loader<HeaderAndBody> onCreateLoader(int id, Bundle bundle) {
        Methods method = (Methods)((Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD"));
        Callback callback = (Callback)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK");
        AbstractAuthenticationLoader loader = null;
        switch (method) {
            case LOGIN: {
                String username = bundle.getString("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME");
                String password = bundle.getString("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD");
                loader = new LoginLoader(this.applicationContext, callback, this.module, username, password);
                break;
            }
            case LOGOUT: {
                loader = new LogoutLoader(this.applicationContext, callback, this.module);
                break;
            }
            case ENROLL: {
                Map params = (Map)((Object)bundle.getSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS"));
                loader = new EnrollLoader(this.applicationContext, callback, this.module, params);
            }
        }
        return loader;
    }

    public void onLoadFinished(Loader<HeaderAndBody> loader, HeaderAndBody data) {
        if (!(loader instanceof AbstractAuthenticationLoader)) {
            Log.e((String)TAG, (String)"Adapter is listening to loaders which it doesn't support");
            throw new IllegalStateException("Adapter is listening to loaders which it doesn't support");
        }
        AbstractAuthenticationLoader modernLoader = (AbstractAuthenticationLoader)loader;
        this.handler.post((Runnable)new CallbackHandler(this, modernLoader, data));
    }

    public void onLoaderReset(Loader<HeaderAndBody> loader) {
    }

    private void fragmentSuccess(Callback<HeaderAndBody> typelessCallback, HeaderAndBody data) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onSuccess(data);
        callback.setFragment(null);
    }

    private void fragmentFailure(Callback<HeaderAndBody> typelessCallback, Exception exception) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onFailure(exception);
        callback.setFragment(null);
    }

    private void activitySuccess(Callback<HeaderAndBody> typelessCallback, HeaderAndBody data) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onSuccess(data);
        callback.setActivity(null);
    }

    private void activityFailure(Callback<HeaderAndBody> typelessCallback, Exception exception) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onFailure(exception);
        callback.setActivity(null);
    }

    static final class CallbackHandler
    implements Runnable {
        private final AuthenticationModuleAdapter adapter;
        private final AbstractAuthenticationLoader modernLoader;
        private final HeaderAndBody data;

        public CallbackHandler(AuthenticationModuleAdapter adapter, AbstractAuthenticationLoader loader, HeaderAndBody data) {
            this.adapter = adapter;
            this.modernLoader = loader;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.modernLoader.hasException()) {
                Exception exception = this.modernLoader.getException();
                Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                    this.adapter.fragmentFailure(this.modernLoader.getCallback(), exception);
                } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                    this.adapter.activityFailure(this.modernLoader.getCallback(), exception);
                } else {
                    this.modernLoader.getCallback().onFailure(exception);
                }
            } else if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                this.adapter.fragmentSuccess(this.modernLoader.getCallback(), this.data);
            } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                this.adapter.activitySuccess(this.modernLoader.getCallback(), this.data);
            } else {
                this.modernLoader.getCallback().onSuccess(this.data);
            }
        }
    }

    private static enum Methods {
        LOGIN,
        LOGOUT,
        ENROLL;

    }
}

