/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.xtremelabs.robolectric.bytecode.RobolectricInternals;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewPager
extends ViewGroup {
    private static final String TAG = "ViewPager";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    private static final Comparator<ItemInfo> COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private static final Interpolator sInterpolator = new /* Unavailable Anonymous Inner Class!! */;
    private final ArrayList<ItemInfo> mItems;
    private PagerAdapter mAdapter;
    private int mCurItem;
    private int mRestoredCurItem;
    private Parcelable mRestoredAdapterState;
    private ClassLoader mRestoredClassLoader;
    private Scroller mScroller;
    private PagerObserver mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mTopPageBounds;
    private int mBottomPageBounds;
    private int mChildWidthMeasureSpec;
    private int mChildHeightMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private boolean mScrolling;
    private int mOffscreenPageLimit;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private int mTouchSlop;
    private float mInitialMotionX;
    private float mLastMotionX;
    private float mLastMotionY;
    private int mActivePointerId;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mFlingDistance;
    private boolean mFakeDragging;
    private long mFakeDragBeginTime;
    private EdgeEffectCompat mLeftEdge;
    private EdgeEffectCompat mRightEdge;
    private boolean mFirstLayout;
    private boolean mCalledSuper;
    private int mDecorChildCount;
    private OnPageChangeListener mOnPageChangeListener;
    private OnPageChangeListener mInternalPageChangeListener;
    private OnAdapterChangeListener mAdapterChangeListener;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState;

    public ViewPager(Context context) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"<init>", (Object)this, (String[])new String[]{"android.content.Context"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)context)});
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"<init>", (Object)this, (String[])new String[]{"android.content.Context", "android.util.AttributeSet"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)context), RobolectricInternals.autobox((Object)attributeSet)});
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void initViewPager() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"initViewPager", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                this.setWillNotDraw(false);
                this.setDescendantFocusability(262144);
                this.setFocusable(true);
                Context context = this.getContext();
                this.mScroller = new Scroller(context, sInterpolator);
                ViewConfiguration configuration = ViewConfiguration.get(context);
                this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
                this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
                this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
                this.mLeftEdge = new EdgeEffectCompat(context);
                this.mRightEdge = new EdgeEffectCompat(context);
                float density = context.getResources().getDisplayMetrics().density;
                this.mFlingDistance = (int)(25.0f * density);
            }
        }
        finally {
            Object var5_6 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void setScrollState(int newState) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setScrollState", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)newState)});
            } else if (this.mScrollState == newState) {
            } else {
                this.mScrollState = newState;
                if (this.mOnPageChangeListener != null) {
                    this.mOnPageChangeListener.onPageScrollStateChanged(newState);
                }
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setAdapter", (Object)this, (String[])new String[]{"android.support.v4.view.PagerAdapter"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)adapter)});
            } else {
                if (this.mAdapter != null) {
                    this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mObserver);
                    this.mAdapter.startUpdate(this);
                    for (int i = 0; i < this.mItems.size(); ++i) {
                        ItemInfo ii = this.mItems.get(i);
                        this.mAdapter.destroyItem(this, ii.position, ii.object);
                    }
                    this.mAdapter.finishUpdate(this);
                    this.mItems.clear();
                    this.removeNonDecorViews();
                    this.mCurItem = 0;
                    this.scrollTo(0, 0);
                }
                PagerAdapter oldAdapter = this.mAdapter;
                this.mAdapter = adapter;
                if (this.mAdapter != null) {
                    if (this.mObserver == null) {
                        this.mObserver = new PagerObserver(this, null);
                    }
                    this.mAdapter.registerDataSetObserver((DataSetObserver)this.mObserver);
                    this.mPopulatePending = false;
                    if (this.mRestoredCurItem >= 0) {
                        this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                        this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                        this.mRestoredCurItem = -1;
                        this.mRestoredAdapterState = null;
                        this.mRestoredClassLoader = null;
                    } else {
                        this.populate();
                    }
                }
                if (this.mAdapterChangeListener != null && oldAdapter != adapter) {
                    this.mAdapterChangeListener.onAdapterChanged(oldAdapter, adapter);
                }
            }
        }
        finally {
            Object var5_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void removeNonDecorViews() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"removeNonDecorViews", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    LayoutParams lp = (LayoutParams)child.getLayoutParams();
                    if (lp.isDecor) continue;
                    this.removeViewAt(i);
                    --i;
                }
            }
        }
        finally {
            Object var5_6 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public PagerAdapter getAdapter() {
        PagerAdapter pagerAdapter;
        try {
            Object object;
            pagerAdapter = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"getAdapter", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (PagerAdapter)object : null) : this.mAdapter;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        PagerAdapter pagerAdapter2 = pagerAdapter;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return pagerAdapter2;
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener listener) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setOnAdapterChangeListener", (Object)this, (String[])new String[]{"android.support.v4.view.ViewPager$OnAdapterChangeListener"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)listener)});
            } else {
                this.mAdapterChangeListener = listener;
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setCurrentItem(int item) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setCurrentItem", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)item)});
            } else {
                this.mPopulatePending = false;
                this.setCurrentItemInternal(item, !this.mFirstLayout, false);
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setCurrentItem", (Object)this, (String[])new String[]{"int", "boolean"}, (Object[])new Object[]{RobolectricInternals.autobox((int)item), RobolectricInternals.autobox((boolean)smoothScroll)});
            } else {
                this.mPopulatePending = false;
                this.setCurrentItemInternal(item, smoothScroll, false);
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public int getCurrentItem() {
        int n;
        try {
            Object object;
            n = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"getCurrentItem", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (Integer)object : 0) : this.mCurItem;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setCurrentItemInternal", (Object)this, (String[])new String[]{"int", "boolean", "boolean"}, (Object[])new Object[]{RobolectricInternals.autobox((int)item), RobolectricInternals.autobox((boolean)smoothScroll), RobolectricInternals.autobox((boolean)always)});
            } else {
                this.setCurrentItemInternal(item, smoothScroll, always, 0);
            }
        }
        finally {
            Object var5_6 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setCurrentItemInternal", (Object)this, (String[])new String[]{"int", "boolean", "boolean", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)item), RobolectricInternals.autobox((boolean)smoothScroll), RobolectricInternals.autobox((boolean)always), RobolectricInternals.autobox((int)velocity)});
            } else if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
                this.setScrollingCacheEnabled(false);
            } else if (!always && this.mCurItem == item && this.mItems.size() != 0) {
                this.setScrollingCacheEnabled(false);
            } else {
                if (item < 0) {
                    item = 0;
                } else if (item >= this.mAdapter.getCount()) {
                    item = this.mAdapter.getCount() - 1;
                }
                int pageLimit = this.mOffscreenPageLimit;
                if (item > this.mCurItem + pageLimit || item < this.mCurItem - pageLimit) {
                    for (int i = 0; i < this.mItems.size(); ++i) {
                        this.mItems.get((int)i).scrolling = true;
                    }
                }
                boolean dispatchSelected = this.mCurItem != item;
                this.mCurItem = item;
                this.populate();
                int destX = (this.getWidth() + this.mPageMargin) * item;
                if (smoothScroll) {
                    this.smoothScrollTo(destX, 0, velocity);
                    if (dispatchSelected && this.mOnPageChangeListener != null) {
                        this.mOnPageChangeListener.onPageSelected(item);
                    }
                    if (dispatchSelected && this.mInternalPageChangeListener != null) {
                        this.mInternalPageChangeListener.onPageSelected(item);
                    }
                } else {
                    if (dispatchSelected && this.mOnPageChangeListener != null) {
                        this.mOnPageChangeListener.onPageSelected(item);
                    }
                    if (dispatchSelected && this.mInternalPageChangeListener != null) {
                        this.mInternalPageChangeListener.onPageSelected(item);
                    }
                    this.completeScroll();
                    this.scrollTo(destX, 0);
                }
            }
        }
        finally {
            Object var9_10 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setOnPageChangeListener(OnPageChangeListener listener) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setOnPageChangeListener", (Object)this, (String[])new String[]{"android.support.v4.view.ViewPager$OnPageChangeListener"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)listener)});
            } else {
                this.mOnPageChangeListener = listener;
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener listener) {
        Object object;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"setInternalPageChangeListener", (Object)this, (String[])new String[]{"android.support.v4.view.ViewPager$OnPageChangeListener"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)listener)});
                object = object2 != null ? (OnPageChangeListener)object2 : null;
            } else {
                OnPageChangeListener oldListener = this.mInternalPageChangeListener;
                this.mInternalPageChangeListener = listener;
                object = oldListener;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        OnPageChangeListener onPageChangeListener = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return onPageChangeListener;
    }

    public int getOffscreenPageLimit() {
        int n;
        try {
            Object object;
            n = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"getOffscreenPageLimit", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (Integer)object : 0) : this.mOffscreenPageLimit;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    public void setOffscreenPageLimit(int limit) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setOffscreenPageLimit", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)limit)});
            } else {
                if (limit < 1) {
                    Log.w(TAG, "Requested offscreen page limit " + limit + " too small; defaulting to " + 1);
                    limit = 1;
                }
                if (limit != this.mOffscreenPageLimit) {
                    this.mOffscreenPageLimit = limit;
                    this.populate();
                }
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setPageMargin(int marginPixels) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setPageMargin", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)marginPixels)});
            } else {
                int oldMargin = this.mPageMargin;
                this.mPageMargin = marginPixels;
                int width = this.getWidth();
                this.recomputeScrollPosition(width, width, marginPixels, oldMargin);
                this.requestLayout();
            }
        }
        finally {
            Object var5_6 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public int getPageMargin() {
        int n;
        try {
            Object object;
            n = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"getPageMargin", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (Integer)object : 0) : this.mPageMargin;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    public void setPageMarginDrawable(Drawable d) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setPageMarginDrawable", (Object)this, (String[])new String[]{"android.graphics.drawable.Drawable"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)d)});
            } else {
                this.mMarginDrawable = d;
                if (d != null) {
                    this.refreshDrawableState();
                }
                this.setWillNotDraw(d == null);
                this.invalidate();
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setPageMarginDrawable(int resId) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setPageMarginDrawable", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)resId)});
            } else {
                this.setPageMarginDrawable(this.getContext().getResources().getDrawable(resId));
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        boolean bl;
        try {
            Object object;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"verifyDrawable", (Object)this, (String[])new String[]{"android.graphics.drawable.Drawable"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)who)})) != null ? (Boolean)object : false) : super.verifyDrawable(who) || who == this.mMarginDrawable;
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    protected void drawableStateChanged() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"drawableStateChanged", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                super.drawableStateChanged();
                Drawable d = this.mMarginDrawable;
                if (d != null && d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    float distanceInfluenceForSnapDuration(float f) {
        float f2;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"distanceInfluenceForSnapDuration", (Object)this, (String[])new String[]{"float"}, (Object[])new Object[]{RobolectricInternals.autobox((float)f)});
                f2 = object != null ? ((Float)object).floatValue() : 0.0f;
            } else {
                f -= 0.5f;
                f = (float)((double)f * 0.4712389167638204);
                f2 = (float)Math.sin(f);
            }
        }
        catch (Throwable throwable) {
            float f3 = 0.0f;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        float f4 = f2;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return f4;
    }

    void smoothScrollTo(int x, int y) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"smoothScrollTo", (Object)this, (String[])new String[]{"int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)x), RobolectricInternals.autobox((int)y)});
            } else {
                this.smoothScrollTo(x, y, 0);
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void smoothScrollTo(int x, int y, int velocity) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"smoothScrollTo", (Object)this, (String[])new String[]{"int", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)x), RobolectricInternals.autobox((int)y), RobolectricInternals.autobox((int)velocity)});
            } else if (this.getChildCount() == 0) {
                this.setScrollingCacheEnabled(false);
            } else {
                int sx = this.getScrollX();
                int sy = this.getScrollY();
                int dx = x - sx;
                int dy = y - sy;
                if (dx == 0 && dy == 0) {
                    this.completeScroll();
                    this.setScrollState(0);
                } else {
                    this.setScrollingCacheEnabled(true);
                    this.mScrolling = true;
                    this.setScrollState(2);
                    int width = this.getWidth();
                    int halfWidth = width / 2;
                    float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
                    float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
                    int duration = 0;
                    velocity = Math.abs(velocity);
                    if (velocity > 0) {
                        duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
                    } else {
                        float pageDelta = (float)Math.abs(dx) / (float)(width + this.mPageMargin);
                        duration = (int)((pageDelta + 1.0f) * 100.0f);
                    }
                    duration = Math.min(duration, 600);
                    this.mScroller.startScroll(sx, sy, dx, dy, duration);
                    this.invalidate();
                }
            }
        }
        finally {
            Object var15_16 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void addNewItem(int position, int index) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"addNewItem", (Object)this, (String[])new String[]{"int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)position), RobolectricInternals.autobox((int)index)});
            } else {
                ItemInfo ii = new ItemInfo();
                ii.position = position;
                ii.object = this.mAdapter.instantiateItem(this, position);
                if (index < 0) {
                    this.mItems.add(ii);
                } else {
                    this.mItems.add(index, ii);
                }
            }
        }
        finally {
            Object var5_6 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void dataSetChanged() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"dataSetChanged", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                boolean needPopulate = this.mItems.size() < 3 && this.mItems.size() < this.mAdapter.getCount();
                int newCurrItem = -1;
                boolean isUpdating = false;
                for (int i = 0; i < this.mItems.size(); ++i) {
                    ItemInfo ii = this.mItems.get(i);
                    int newPos = this.mAdapter.getItemPosition(ii.object);
                    if (newPos == -1) continue;
                    if (newPos == -2) {
                        this.mItems.remove(i);
                        --i;
                        if (!isUpdating) {
                            this.mAdapter.startUpdate(this);
                            isUpdating = true;
                        }
                        this.mAdapter.destroyItem(this, ii.position, ii.object);
                        needPopulate = true;
                        if (this.mCurItem != ii.position) continue;
                        newCurrItem = Math.max(0, Math.min(this.mCurItem, this.mAdapter.getCount() - 1));
                        continue;
                    }
                    if (ii.position == newPos) continue;
                    if (ii.position == this.mCurItem) {
                        newCurrItem = newPos;
                    }
                    ii.position = newPos;
                    needPopulate = true;
                }
                if (isUpdating) {
                    this.mAdapter.finishUpdate(this);
                }
                Collections.sort(this.mItems, COMPARATOR);
                if (newCurrItem >= 0) {
                    this.setCurrentItemInternal(newCurrItem, false, true);
                    needPopulate = true;
                }
                if (needPopulate) {
                    this.populate();
                    this.requestLayout();
                }
            }
        }
        finally {
            Object var8_9 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void populate() {
        block17: {
            try {
                ItemInfo ii;
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    RobolectricInternals.methodInvoked(ViewPager.class, (String)"populate", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                    break block17;
                }
                if (this.mAdapter == null) {
                    break block17;
                }
                if (this.mPopulatePending) {
                    break block17;
                }
                if (this.getWindowToken() == null) {
                    break block17;
                }
                this.mAdapter.startUpdate(this);
                int pageLimit = this.mOffscreenPageLimit;
                int startPos = Math.max(0, this.mCurItem - pageLimit);
                int N = this.mAdapter.getCount();
                int endPos = Math.min(N - 1, this.mCurItem + pageLimit);
                int lastPos = -1;
                for (int i = 0; i < this.mItems.size(); ++i) {
                    ItemInfo ii2 = this.mItems.get(i);
                    if (!(ii2.position >= startPos && ii2.position <= endPos || ii2.scrolling)) {
                        this.mItems.remove(i);
                        --i;
                        this.mAdapter.destroyItem(this, ii2.position, ii2.object);
                    } else if (lastPos < endPos && ii2.position > startPos) {
                        if (++lastPos < startPos) {
                            lastPos = startPos;
                        }
                        while (lastPos <= endPos && lastPos < ii2.position) {
                            this.addNewItem(lastPos, i);
                            ++lastPos;
                            ++i;
                        }
                    }
                    lastPos = ii2.position;
                }
                int n = lastPos = this.mItems.size() > 0 ? this.mItems.get((int)(this.mItems.size() - 1)).position : -1;
                if (lastPos < endPos) {
                    int n2 = lastPos = ++lastPos > startPos ? lastPos : startPos;
                    while (lastPos <= endPos) {
                        this.addNewItem(lastPos, -1);
                        ++lastPos;
                    }
                }
                ItemInfo curItem = null;
                for (int i = 0; i < this.mItems.size(); ++i) {
                    if (this.mItems.get((int)i).position != this.mCurItem) continue;
                    curItem = this.mItems.get(i);
                    break;
                }
                this.mAdapter.setPrimaryItem(this, this.mCurItem, curItem != null ? curItem.object : null);
                this.mAdapter.finishUpdate(this);
                if (!this.hasFocus()) break block17;
                View currentFocused = this.findFocus();
                ItemInfo itemInfo = ii = currentFocused != null ? this.infoForAnyChild(currentFocused) : null;
                if (ii != null && ii.position == this.mCurItem) break block17;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    ii = this.infoForChild(child);
                    if (ii == null || ii.position != this.mCurItem || !child.requestFocus(2)) continue;
                    break;
                }
            }
            finally {
                Object var12_16 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
            }
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable parcelable;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"onSaveInstanceState", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                parcelable = object != null ? (Parcelable)object : null;
            } else {
                Parcelable superState = super.onSaveInstanceState();
                SavedState ss = new SavedState(superState);
                ss.position = this.mCurItem;
                if (this.mAdapter != null) {
                    ss.adapterState = this.mAdapter.saveState();
                }
                parcelable = ss;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        Parcelable parcelable2 = parcelable;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return parcelable2;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onRestoreInstanceState", (Object)this, (String[])new String[]{"android.os.Parcelable"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)state)});
            } else if (!(state instanceof SavedState)) {
                super.onRestoreInstanceState(state);
            } else {
                SavedState ss = (SavedState)state;
                super.onRestoreInstanceState(ss.getSuperState());
                if (this.mAdapter != null) {
                    this.mAdapter.restoreState(ss.adapterState, ss.loader);
                    this.setCurrentItemInternal(ss.position, false, true);
                } else {
                    this.mRestoredCurItem = ss.position;
                    this.mRestoredAdapterState = ss.adapterState;
                    this.mRestoredClassLoader = ss.loader;
                }
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"addView", (Object)this, (String[])new String[]{"android.view.View", "int", "android.view.ViewGroup$LayoutParams"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)child), RobolectricInternals.autobox((int)index), RobolectricInternals.autobox((Object)params)});
            } else {
                if (!this.checkLayoutParams(params)) {
                    params = this.generateLayoutParams(params);
                }
                LayoutParams lp = (LayoutParams)params;
                lp.isDecor |= child instanceof Decor;
                if (this.mInLayout) {
                    if (lp != null && lp.isDecor) {
                        throw new IllegalStateException("Cannot add pager decor view during layout");
                    }
                    this.addViewInLayout(child, index, params);
                    child.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
                } else {
                    super.addView(child, index, params);
                }
            }
        }
        finally {
            Object var6_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    ItemInfo infoForChild(View child) {
        Object object;
        block4: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"infoForChild", (Object)this, (String[])new String[]{"android.view.View"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)child)});
                    object = object2 != null ? (ItemInfo)object2 : null;
                    break block4;
                }
                for (int i = 0; i < this.mItems.size(); ++i) {
                    ItemInfo ii = this.mItems.get(i);
                    if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
                    object = ii;
                    break block4;
                }
                object = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        ItemInfo itemInfo = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return itemInfo;
    }

    ItemInfo infoForAnyChild(View child) {
        Object object;
        block5: {
            try {
                ViewParent parent;
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"infoForAnyChild", (Object)this, (String[])new String[]{"android.view.View"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)child)});
                    object = object2 != null ? (ItemInfo)object2 : null;
                    break block5;
                }
                while ((parent = child.getParent()) != this) {
                    if (parent == null || !(parent instanceof View)) {
                        object = null;
                        break block5;
                    }
                    child = (View)parent;
                }
                object = this.infoForChild(child);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        ItemInfo itemInfo = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return itemInfo;
    }

    @Override
    protected void onAttachedToWindow() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onAttachedToWindow", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                super.onAttachedToWindow();
                this.mFirstLayout = true;
            }
        }
        finally {
            Object var2_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onMeasure", (Object)this, (String[])new String[]{"int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)widthMeasureSpec), RobolectricInternals.autobox((int)heightMeasureSpec)});
            } else {
                LayoutParams lp;
                View child;
                int i;
                this.setMeasuredDimension(ViewPager.getDefaultSize(0, widthMeasureSpec), ViewPager.getDefaultSize(0, heightMeasureSpec));
                int childWidthSize = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
                int childHeightSize = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int size = this.getChildCount();
                for (i = 0; i < size; ++i) {
                    boolean consumeHorizontal;
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) == null || !lp.isDecor) continue;
                    int hgrav = lp.gravity & 7;
                    int vgrav = lp.gravity & 0x70;
                    Log.d(TAG, "gravity: " + lp.gravity + " hgrav: " + hgrav + " vgrav: " + vgrav);
                    int widthMode = Integer.MIN_VALUE;
                    int heightMode = Integer.MIN_VALUE;
                    boolean consumeVertical = vgrav == 48 || vgrav == 80;
                    boolean bl = consumeHorizontal = hgrav == 3 || hgrav == 5;
                    if (consumeVertical) {
                        widthMode = 0x40000000;
                    } else if (consumeHorizontal) {
                        heightMode = 0x40000000;
                    }
                    int widthSpec = View.MeasureSpec.makeMeasureSpec(childWidthSize, widthMode);
                    int heightSpec = View.MeasureSpec.makeMeasureSpec(childHeightSize, heightMode);
                    child.measure(widthSpec, heightSpec);
                    if (consumeVertical) {
                        childHeightSize -= child.getMeasuredHeight();
                        continue;
                    }
                    if (!consumeHorizontal) continue;
                    childWidthSize -= child.getMeasuredWidth();
                }
                this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(childWidthSize, 0x40000000);
                this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(childHeightSize, 0x40000000);
                this.mInLayout = true;
                this.populate();
                this.mInLayout = false;
                size = this.getChildCount();
                for (i = 0; i < size; ++i) {
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) != null && lp.isDecor) continue;
                    child.measure(this.mChildWidthMeasureSpec, this.mChildHeightMeasureSpec);
                }
            }
        }
        finally {
            Object var18_19 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onSizeChanged", (Object)this, (String[])new String[]{"int", "int", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)w), RobolectricInternals.autobox((int)h), RobolectricInternals.autobox((int)oldw), RobolectricInternals.autobox((int)oldh)});
            } else {
                super.onSizeChanged(w, h, oldw, oldh);
                if (w != oldw) {
                    this.recomputeScrollPosition(w, oldw, this.mPageMargin, this.mPageMargin);
                }
            }
        }
        finally {
            Object var6_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void recomputeScrollPosition(int width, int oldWidth, int margin, int oldMargin) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"recomputeScrollPosition", (Object)this, (String[])new String[]{"int", "int", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)width), RobolectricInternals.autobox((int)oldWidth), RobolectricInternals.autobox((int)margin), RobolectricInternals.autobox((int)oldMargin)});
            } else {
                int widthWithMargin = width + margin;
                if (oldWidth > 0) {
                    int oldScrollPos = this.getScrollX();
                    int oldwwm = oldWidth + oldMargin;
                    int oldScrollItem = oldScrollPos / oldwwm;
                    float scrollOffset = (float)(oldScrollPos % oldwwm) / (float)oldwwm;
                    int scrollPos = (int)(((float)oldScrollItem + scrollOffset) * (float)widthWithMargin);
                    this.scrollTo(scrollPos, this.getScrollY());
                    if (!this.mScroller.isFinished()) {
                        int newDuration = this.mScroller.getDuration() - this.mScroller.timePassed();
                        this.mScroller.startScroll(scrollPos, 0, this.mCurItem * widthWithMargin, 0, newDuration);
                    }
                } else {
                    int scrollPos = this.mCurItem * widthWithMargin;
                    if (scrollPos != this.getScrollX()) {
                        this.completeScroll();
                        this.scrollTo(scrollPos, this.getScrollY());
                    }
                }
            }
        }
        finally {
            Object var13_15 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onLayout", (Object)this, (String[])new String[]{"boolean", "int", "int", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((boolean)changed), RobolectricInternals.autobox((int)l), RobolectricInternals.autobox((int)t), RobolectricInternals.autobox((int)r), RobolectricInternals.autobox((int)b)});
            } else {
                this.mInLayout = true;
                this.populate();
                this.mInLayout = false;
                int count = this.getChildCount();
                int width = r - l;
                int height = b - t;
                int paddingLeft = this.getPaddingLeft();
                int paddingTop = this.getPaddingTop();
                int paddingRight = this.getPaddingRight();
                int paddingBottom = this.getPaddingBottom();
                int scrollX = this.getScrollX();
                int decorCount = 0;
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    LayoutParams lp = (LayoutParams)child.getLayoutParams();
                    int childLeft = 0;
                    int childTop = 0;
                    if (lp.isDecor) {
                        int hgrav = lp.gravity & 7;
                        int vgrav = lp.gravity & 0x70;
                        switch (hgrav) {
                            default: {
                                childLeft = paddingLeft;
                                break;
                            }
                            case 3: {
                                childLeft = paddingLeft;
                                paddingLeft += child.getMeasuredWidth();
                                break;
                            }
                            case 1: {
                                childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                                break;
                            }
                            case 5: {
                                childLeft = width - paddingRight - child.getMeasuredWidth();
                                paddingRight += child.getMeasuredWidth();
                            }
                        }
                        switch (vgrav) {
                            default: {
                                childTop = paddingTop;
                                break;
                            }
                            case 48: {
                                childTop = paddingTop;
                                paddingTop += child.getMeasuredHeight();
                                break;
                            }
                            case 16: {
                                childTop = Math.max((height - child.getMeasuredHeight()) / 2, paddingTop);
                                break;
                            }
                            case 80: {
                                childTop = height - paddingBottom - child.getMeasuredHeight();
                                paddingBottom += child.getMeasuredHeight();
                            }
                        }
                        ++decorCount;
                        child.layout(childLeft += scrollX, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                        continue;
                    }
                    ItemInfo ii = this.infoForChild(child);
                    if (ii == null) continue;
                    int loff = (width + this.mPageMargin) * ii.position;
                    childLeft = paddingLeft + loff;
                    childTop = paddingTop;
                    child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                }
                this.mTopPageBounds = paddingTop;
                this.mBottomPageBounds = height - paddingBottom;
                this.mDecorChildCount = decorCount;
                this.mFirstLayout = false;
            }
        }
        finally {
            Object var24_25 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    public void computeScroll() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"computeScroll", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
                int oldX = this.getScrollX();
                int oldY = this.getScrollY();
                int x = this.mScroller.getCurrX();
                int y = this.mScroller.getCurrY();
                if (oldX != x || oldY != y) {
                    this.scrollTo(x, y);
                    this.pageScrolled(x);
                }
                this.invalidate();
            } else {
                this.completeScroll();
            }
        }
        finally {
            Object var6_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void pageScrolled(int xpos) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"pageScrolled", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)xpos)});
            } else {
                int widthWithMargin = this.getWidth() + this.mPageMargin;
                int position = xpos / widthWithMargin;
                int offsetPixels = xpos % widthWithMargin;
                float offset = (float)offsetPixels / (float)widthWithMargin;
                this.mCalledSuper = false;
                this.onPageScrolled(position, offset, offsetPixels);
                if (!this.mCalledSuper) {
                    throw new IllegalStateException("onPageScrolled did not call superclass implementation");
                }
            }
        }
        finally {
            Object var7_8 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onPageScrolled", (Object)this, (String[])new String[]{"int", "float", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)position), RobolectricInternals.autobox((float)offset), RobolectricInternals.autobox((int)offsetPixels)});
            } else {
                if (this.mDecorChildCount > 0) {
                    int scrollX = this.getScrollX();
                    int paddingLeft = this.getPaddingLeft();
                    int paddingRight = this.getPaddingRight();
                    int width = this.getWidth();
                    int childCount = this.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        View child = this.getChildAt(i);
                        LayoutParams lp = (LayoutParams)child.getLayoutParams();
                        if (!lp.isDecor) continue;
                        int hgrav = lp.gravity & 7;
                        int childLeft = 0;
                        switch (hgrav) {
                            default: {
                                childLeft = paddingLeft;
                                break;
                            }
                            case 3: {
                                childLeft = paddingLeft;
                                paddingLeft += child.getWidth();
                                break;
                            }
                            case 1: {
                                childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                                break;
                            }
                            case 5: {
                                childLeft = width - paddingRight - child.getMeasuredWidth();
                                paddingRight += child.getMeasuredWidth();
                            }
                        }
                        int childOffset = (childLeft += scrollX) - child.getLeft();
                        if (childOffset == 0) continue;
                        child.offsetLeftAndRight(childOffset);
                    }
                }
                if (this.mOnPageChangeListener != null) {
                    this.mOnPageChangeListener.onPageScrolled(position, offset, offsetPixels);
                }
                if (this.mInternalPageChangeListener != null) {
                    this.mInternalPageChangeListener.onPageScrolled(position, offset, offsetPixels);
                }
                this.mCalledSuper = true;
            }
        }
        finally {
            Object var16_17 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void completeScroll() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"completeScroll", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                boolean needPopulate = this.mScrolling;
                if (needPopulate) {
                    this.setScrollingCacheEnabled(false);
                    this.mScroller.abortAnimation();
                    int oldX = this.getScrollX();
                    int oldY = this.getScrollY();
                    int x = this.mScroller.getCurrX();
                    int y = this.mScroller.getCurrY();
                    if (oldX != x || oldY != y) {
                        this.scrollTo(x, y);
                    }
                    this.setScrollState(0);
                }
                this.mPopulatePending = false;
                this.mScrolling = false;
                for (int i = 0; i < this.mItems.size(); ++i) {
                    ItemInfo ii = this.mItems.get(i);
                    if (!ii.scrolling) continue;
                    needPopulate = true;
                    ii.scrolling = false;
                }
                if (needPopulate) {
                    this.populate();
                }
            }
        }
        finally {
            Object var7_9 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean bl;
        block19: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"onInterceptTouchEvent", (Object)this, (String[])new String[]{"android.view.MotionEvent"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)ev)});
                    bl = object != null ? (Boolean)object : false;
                    break block19;
                }
                int action = ev.getAction() & 0xFF;
                if (action == 3 || action == 1) {
                    this.mIsBeingDragged = false;
                    this.mIsUnableToDrag = false;
                    this.mActivePointerId = -1;
                    if (this.mVelocityTracker != null) {
                        this.mVelocityTracker.recycle();
                        this.mVelocityTracker = null;
                    }
                    bl = false;
                    break block19;
                }
                if (action != 0) {
                    if (this.mIsBeingDragged) {
                        bl = true;
                        break block19;
                    }
                    if (this.mIsUnableToDrag) {
                        bl = false;
                        break block19;
                    }
                }
                switch (action) {
                    case 2: {
                        int activePointerId = this.mActivePointerId;
                        if (activePointerId == -1) break;
                        int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                        float x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                        float dx = x - this.mLastMotionX;
                        float xDiff = Math.abs(dx);
                        float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                        float yDiff = Math.abs(y - this.mLastMotionY);
                        if (this.canScroll(this, false, (int)dx, (int)x, (int)y)) {
                            this.mInitialMotionX = this.mLastMotionX = x;
                            this.mLastMotionY = y;
                            bl = false;
                            break block19;
                        } else {
                            if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                                this.mIsBeingDragged = true;
                                this.setScrollState(1);
                                this.mLastMotionX = x;
                                this.setScrollingCacheEnabled(true);
                                break;
                            }
                            if (!(yDiff > (float)this.mTouchSlop)) break;
                            this.mIsUnableToDrag = true;
                            break;
                        }
                    }
                    case 0: {
                        this.mLastMotionX = this.mInitialMotionX = ev.getX();
                        this.mLastMotionY = ev.getY();
                        this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                        if (this.mScrollState == 2) {
                            this.mIsBeingDragged = true;
                            this.mIsUnableToDrag = false;
                            this.setScrollState(1);
                            break;
                        }
                        this.completeScroll();
                        this.mIsBeingDragged = false;
                        this.mIsUnableToDrag = false;
                        break;
                    }
                    case 6: {
                        this.onSecondaryPointerUp(ev);
                    }
                }
                if (!this.mIsBeingDragged) {
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    }
                    this.mVelocityTracker.addMovement(ev);
                }
                bl = this.mIsBeingDragged;
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"onTouchEvent", (Object)this, (String[])new String[]{"android.view.MotionEvent"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)ev)});
                bl = object != null ? (Boolean)object : false;
            } else if (this.mFakeDragging) {
                bl = true;
            } else if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
                bl = false;
            } else if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
                bl = false;
            } else {
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
                this.mVelocityTracker.addMovement(ev);
                int action = ev.getAction();
                boolean needsInvalidate = false;
                switch (action & 0xFF) {
                    case 0: {
                        this.completeScroll();
                        this.mLastMotionX = this.mInitialMotionX = ev.getX();
                        this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                        break;
                    }
                    case 2: {
                        float x;
                        if (!this.mIsBeingDragged) {
                            int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                            x = MotionEventCompat.getX((MotionEvent)ev, (int)pointerIndex);
                            float xDiff = Math.abs(x - this.mLastMotionX);
                            float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                            float yDiff = Math.abs(y - this.mLastMotionY);
                            if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                                this.mIsBeingDragged = true;
                                this.mLastMotionX = x;
                                this.setScrollState(1);
                                this.setScrollingCacheEnabled(true);
                            }
                        }
                        if (!this.mIsBeingDragged) break;
                        int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                        x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                        float deltaX = this.mLastMotionX - x;
                        this.mLastMotionX = x;
                        float oldScrollX = this.getScrollX();
                        float scrollX = oldScrollX + deltaX;
                        int width = this.getWidth();
                        int widthWithMargin = width + this.mPageMargin;
                        int lastItemIndex = this.mAdapter.getCount() - 1;
                        float leftBound = Math.max(0, (this.mCurItem - 1) * widthWithMargin);
                        float rightBound = Math.min(this.mCurItem + 1, lastItemIndex) * widthWithMargin;
                        if (scrollX < leftBound) {
                            if (leftBound == 0.0f) {
                                float over = -scrollX;
                                needsInvalidate = this.mLeftEdge.onPull(over / (float)width);
                            }
                            scrollX = leftBound;
                        } else if (scrollX > rightBound) {
                            if (rightBound == (float)(lastItemIndex * widthWithMargin)) {
                                float over = scrollX - rightBound;
                                needsInvalidate = this.mRightEdge.onPull(over / (float)width);
                            }
                            scrollX = rightBound;
                        }
                        this.mLastMotionX += scrollX - (float)((int)scrollX);
                        this.scrollTo((int)scrollX, this.getScrollY());
                        this.pageScrolled((int)scrollX);
                        break;
                    }
                    case 1: {
                        if (!this.mIsBeingDragged) break;
                        VelocityTracker velocityTracker = this.mVelocityTracker;
                        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        int initialVelocity = (int)VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                        this.mPopulatePending = true;
                        int widthWithMargin = this.getWidth() + this.mPageMargin;
                        int scrollX = this.getScrollX();
                        int currentPage = scrollX / widthWithMargin;
                        float pageOffset = (float)(scrollX % widthWithMargin) / (float)widthWithMargin;
                        int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                        float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                        int totalDelta = (int)(x - this.mInitialMotionX);
                        int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
                        this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                        this.mActivePointerId = -1;
                        this.endDrag();
                        needsInvalidate = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                        break;
                    }
                    case 3: {
                        if (!this.mIsBeingDragged) break;
                        this.setCurrentItemInternal(this.mCurItem, true, true);
                        this.mActivePointerId = -1;
                        this.endDrag();
                        needsInvalidate = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                        break;
                    }
                    case 5: {
                        float x;
                        int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                        this.mLastMotionX = x = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                        this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                        break;
                    }
                    case 6: {
                        this.onSecondaryPointerUp(ev);
                        this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
                    }
                }
                if (needsInvalidate) {
                    this.invalidate();
                }
                bl = true;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    private int determineTargetPage(int currentPage, float pageOffset, int velocity, int deltaX) {
        int n;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"determineTargetPage", (Object)this, (String[])new String[]{"int", "float", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)currentPage), RobolectricInternals.autobox((float)pageOffset), RobolectricInternals.autobox((int)velocity), RobolectricInternals.autobox((int)deltaX)});
                n = object != null ? (Integer)object : 0;
            } else {
                int targetPage = Math.abs(deltaX) > this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity ? (velocity > 0 ? currentPage : currentPage + 1) : (int)((float)currentPage + pageOffset + 0.5f);
                n = targetPage;
            }
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    @Override
    public void draw(Canvas canvas) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"draw", (Object)this, (String[])new String[]{"android.graphics.Canvas"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)canvas)});
            } else {
                super.draw(canvas);
                boolean needsInvalidate = false;
                int overScrollMode = ViewCompat.getOverScrollMode((View)this);
                if (overScrollMode == 0 || overScrollMode == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
                    int restoreCount;
                    if (!this.mLeftEdge.isFinished()) {
                        restoreCount = canvas.save();
                        int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                        canvas.rotate(270.0f);
                        canvas.translate(-height + this.getPaddingTop(), 0.0f);
                        this.mLeftEdge.setSize(height, this.getWidth());
                        needsInvalidate |= this.mLeftEdge.draw(canvas);
                        canvas.restoreToCount(restoreCount);
                    }
                    if (!this.mRightEdge.isFinished()) {
                        restoreCount = canvas.save();
                        int width = this.getWidth();
                        int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                        int itemCount = this.mAdapter != null ? this.mAdapter.getCount() : 1;
                        canvas.rotate(90.0f);
                        canvas.translate(-this.getPaddingTop(), -itemCount * (width + this.mPageMargin) + this.mPageMargin);
                        this.mRightEdge.setSize(height, width);
                        needsInvalidate |= this.mRightEdge.draw(canvas);
                        canvas.restoreToCount(restoreCount);
                    }
                } else {
                    this.mLeftEdge.finish();
                    this.mRightEdge.finish();
                }
                if (needsInvalidate) {
                    this.invalidate();
                }
            }
        }
        finally {
            Object var9_10 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onDraw", (Object)this, (String[])new String[]{"android.graphics.Canvas"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)canvas)});
            } else {
                int width;
                int scrollX;
                int offset;
                super.onDraw(canvas);
                if (this.mPageMargin > 0 && this.mMarginDrawable != null && (offset = (scrollX = this.getScrollX()) % ((width = this.getWidth()) + this.mPageMargin)) != 0) {
                    int left = scrollX - offset + width;
                    this.mMarginDrawable.setBounds(left, this.mTopPageBounds, left + this.mPageMargin, this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
            }
        }
        finally {
            Object var7_8 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public boolean beginFakeDrag() {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"beginFakeDrag", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                bl = object != null ? (Boolean)object : false;
            } else if (this.mIsBeingDragged) {
                bl = false;
            } else {
                this.mFakeDragging = true;
                this.setScrollState(1);
                this.mLastMotionX = 0.0f;
                this.mInitialMotionX = 0.0f;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                } else {
                    this.mVelocityTracker.clear();
                }
                long time = SystemClock.uptimeMillis();
                MotionEvent ev = MotionEvent.obtain(time, time, 0, 0.0f, 0.0f, 0);
                this.mVelocityTracker.addMovement(ev);
                ev.recycle();
                this.mFakeDragBeginTime = time;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    public void endFakeDrag() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"endFakeDrag", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                if (!this.mFakeDragging) {
                    throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                this.mPopulatePending = true;
                int totalDelta = (int)(this.mLastMotionX - this.mInitialMotionX);
                int scrollX = this.getScrollX();
                int widthWithMargin = this.getWidth() + this.mPageMargin;
                int currentPage = scrollX / widthWithMargin;
                float pageOffset = (float)(scrollX % widthWithMargin) / (float)widthWithMargin;
                int nextPage = this.determineTargetPage(currentPage, pageOffset, initialVelocity, totalDelta);
                this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                this.endDrag();
                this.mFakeDragging = false;
            }
        }
        finally {
            Object var10_11 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void fakeDragBy(float xOffset) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"fakeDragBy", (Object)this, (String[])new String[]{"float"}, (Object[])new Object[]{RobolectricInternals.autobox((float)xOffset)});
            } else {
                if (!this.mFakeDragging) {
                    throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
                }
                this.mLastMotionX += xOffset;
                float scrollX = (float)this.getScrollX() - xOffset;
                int width = this.getWidth();
                int widthWithMargin = width + this.mPageMargin;
                float leftBound = Math.max(0, (this.mCurItem - 1) * widthWithMargin);
                float rightBound = Math.min(this.mCurItem + 1, this.mAdapter.getCount() - 1) * widthWithMargin;
                if (scrollX < leftBound) {
                    scrollX = leftBound;
                } else if (scrollX > rightBound) {
                    scrollX = rightBound;
                }
                this.mLastMotionX += scrollX - (float)((int)scrollX);
                this.scrollTo((int)scrollX, this.getScrollY());
                this.pageScrolled((int)scrollX);
                long time = SystemClock.uptimeMillis();
                MotionEvent ev = MotionEvent.obtain(this.mFakeDragBeginTime, time, 2, this.mLastMotionX, 0.0f, 0);
                this.mVelocityTracker.addMovement(ev);
                ev.recycle();
            }
        }
        finally {
            Object var11_11 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public boolean isFakeDragging() {
        boolean bl;
        try {
            Object object;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"isFakeDragging", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (Boolean)object : false) : this.mFakeDragging;
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"onSecondaryPointerUp", (Object)this, (String[])new String[]{"android.view.MotionEvent"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)ev)});
            } else {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)newPointerIndex);
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
                    if (this.mVelocityTracker != null) {
                        this.mVelocityTracker.clear();
                    }
                }
            }
        }
        finally {
            Object var6_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void endDrag() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"endDrag", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                this.mIsBeingDragged = false;
                this.mIsUnableToDrag = false;
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
            }
        }
        finally {
            Object var2_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void setScrollingCacheEnabled(boolean enabled) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"setScrollingCacheEnabled", (Object)this, (String[])new String[]{"boolean"}, (Object[])new Object[]{RobolectricInternals.autobox((boolean)enabled)});
            } else if (this.mScrollingCacheEnabled != enabled) {
                this.mScrollingCacheEnabled = enabled;
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"canScroll", (Object)this, (String[])new String[]{"android.view.View", "boolean", "int", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)v), RobolectricInternals.autobox((boolean)checkV), RobolectricInternals.autobox((int)dx), RobolectricInternals.autobox((int)x), RobolectricInternals.autobox((int)y)});
                bl = object != null ? (Boolean)object : false;
            } else if (v instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)v;
                int scrollX = v.getScrollX();
                int scrollY = v.getScrollY();
                int count = group.getChildCount();
                for (int i = count - 1; i >= 0; --i) {
                    View child = group.getChildAt(i);
                    if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = checkV && ViewCompat.canScrollHorizontally((View)v, (int)(-dx));
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean bl;
        try {
            Object object;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"dispatchKeyEvent", (Object)this, (String[])new String[]{"android.view.KeyEvent"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)event)})) != null ? (Boolean)object : false) : super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    public boolean executeKeyEvent(KeyEvent event) {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"executeKeyEvent", (Object)this, (String[])new String[]{"android.view.KeyEvent"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)event)});
                bl = object != null ? (Boolean)object : false;
            } else {
                boolean handled = false;
                if (event.getAction() == 0) {
                    switch (event.getKeyCode()) {
                        case 21: {
                            handled = this.arrowScroll(17);
                            break;
                        }
                        case 22: {
                            handled = this.arrowScroll(66);
                            break;
                        }
                        case 61: {
                            if (Build.VERSION.SDK_INT < 11) break;
                            if (KeyEventCompat.hasNoModifiers((KeyEvent)event)) {
                                handled = this.arrowScroll(2);
                                break;
                            }
                            if (!KeyEventCompat.hasModifiers((KeyEvent)event, (int)1)) break;
                            handled = this.arrowScroll(1);
                        }
                    }
                }
                bl = handled;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    public boolean arrowScroll(int direction) {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"arrowScroll", (Object)this, (String[])new String[]{"int"}, (Object[])new Object[]{RobolectricInternals.autobox((int)direction)});
                bl = object != null ? (Boolean)object : false;
            } else {
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                boolean handled = false;
                View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
                if (nextFocused != null && nextFocused != currentFocused) {
                    if (direction == 17) {
                        handled = currentFocused != null && nextFocused.getLeft() >= currentFocused.getLeft() ? this.pageLeft() : nextFocused.requestFocus();
                    } else if (direction == 66) {
                        handled = currentFocused != null && nextFocused.getLeft() <= currentFocused.getLeft() ? this.pageRight() : nextFocused.requestFocus();
                    }
                } else if (direction == 17 || direction == 1) {
                    handled = this.pageLeft();
                } else if (direction == 66 || direction == 2) {
                    handled = this.pageRight();
                }
                if (handled) {
                    this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)direction));
                }
                bl = handled;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    boolean pageLeft() {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"pageLeft", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                bl = object != null ? (Boolean)object : false;
            } else if (this.mCurItem > 0) {
                this.setCurrentItem(this.mCurItem - 1, true);
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    boolean pageRight() {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"pageRight", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                bl = object != null ? (Boolean)object : false;
            } else if (this.mAdapter != null && this.mCurItem < this.mAdapter.getCount() - 1) {
                this.setCurrentItem(this.mCurItem + 1, true);
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"addFocusables", (Object)this, (String[])new String[]{"java.util.ArrayList", "int", "int"}, (Object[])new Object[]{RobolectricInternals.autobox(views), RobolectricInternals.autobox((int)direction), RobolectricInternals.autobox((int)focusableMode)});
            } else {
                int focusableCount = views.size();
                int descendantFocusability = this.getDescendantFocusability();
                if (descendantFocusability != 393216) {
                    for (int i = 0; i < this.getChildCount(); ++i) {
                        ItemInfo ii;
                        View child = this.getChildAt(i);
                        if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
                        child.addFocusables(views, direction, focusableMode);
                    }
                }
                if (descendantFocusability != 262144 || focusableCount == views.size()) {
                    if (!this.isFocusable()) {
                    } else if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                    } else if (views != null) {
                        views.add(this);
                    }
                }
            }
        }
        finally {
            Object var10_11 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    public void addTouchables(ArrayList<View> views) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"addTouchables", (Object)this, (String[])new String[]{"java.util.ArrayList"}, (Object[])new Object[]{RobolectricInternals.autobox(views)});
            } else {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ItemInfo ii;
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
                    child.addTouchables(views);
                }
            }
        }
        finally {
            Object var6_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        boolean bl;
        block6: {
            try {
                int end;
                int increment;
                int index;
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"onRequestFocusInDescendants", (Object)this, (String[])new String[]{"int", "android.graphics.Rect"}, (Object[])new Object[]{RobolectricInternals.autobox((int)direction), RobolectricInternals.autobox((Object)previouslyFocusedRect)});
                    bl = object != null ? (Boolean)object : false;
                    break block6;
                }
                int count = this.getChildCount();
                if ((direction & 2) != 0) {
                    index = 0;
                    increment = 1;
                    end = count;
                } else {
                    index = count - 1;
                    increment = -1;
                    end = -1;
                }
                for (int i = index; i != end; i += increment) {
                    ItemInfo ii;
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.requestFocus(direction, previouslyFocusedRect)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        boolean bl;
        block4: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"dispatchPopulateAccessibilityEvent", (Object)this, (String[])new String[]{"android.view.accessibility.AccessibilityEvent"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)event)});
                    bl = object != null ? (Boolean)object : false;
                    break block4;
                }
                int childCount = this.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    ItemInfo ii;
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.dispatchPopulateAccessibilityEvent(event)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        Object object;
        try {
            Object object2;
            object = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"generateDefaultLayoutParams", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (ViewGroup.LayoutParams)object2 : null) : new LayoutParams();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        LayoutParams layoutParams = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return layoutParams;
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        ViewGroup.LayoutParams layoutParams;
        try {
            Object object;
            layoutParams = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"generateLayoutParams", (Object)this, (String[])new String[]{"android.view.ViewGroup$LayoutParams"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)p)})) != null ? (ViewGroup.LayoutParams)object : null) : this.generateDefaultLayoutParams();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        ViewGroup.LayoutParams layoutParams2 = layoutParams;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return layoutParams2;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        boolean bl;
        try {
            Object object;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"checkLayoutParams", (Object)this, (String[])new String[]{"android.view.ViewGroup$LayoutParams"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)p)})) != null ? (Boolean)object : false) : p instanceof LayoutParams && super.checkLayoutParams(p);
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        Object object;
        try {
            Object object2;
            object = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"generateLayoutParams", (Object)this, (String[])new String[]{"android.util.AttributeSet"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)attrs)})) != null ? (ViewGroup.LayoutParams)object2 : null) : new LayoutParams(this.getContext(), attrs);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        LayoutParams layoutParams = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return layoutParams;
    }

    static /* synthetic */ int[] access$100() {
        Object object;
        try {
            Object object2;
            object = !RobolectricInternals.shouldCallDirectly(ViewPager.class) ? (Object)((object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"access$100", null, (String[])new String[0], (Object[])new Object[0])) != null ? (int[])object2 : null) : LAYOUT_ATTRS;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            RobolectricInternals.onMethodInvocationFinish(ViewPager.class);
            throw throwable;
        }
        int[] nArray = object;
        RobolectricInternals.onMethodInvocationFinish(ViewPager.class);
        return nArray;
    }

    public ViewPager() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(ViewPager.class, (String)"<init>", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            }
        }
        finally {
            Object var2_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        try {
            Object object2;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(ViewPager.class, (String)"equals", (Object)this, (String[])new String[]{"java.lang.Object"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)object)})) != null ? ((Boolean)object2).booleanValue() : super.equals(object)) : super.equals(object);
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public int hashCode() {
        int n;
        try {
            Object object;
            n = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"hashCode", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? ((Integer)object).intValue() : super.hashCode()) : super.hashCode();
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    @Override
    public String toString() {
        String string;
        try {
            Object object;
            string = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(ViewPager.class, (String)"toString", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (String)object : super.toString()) : super.toString();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        String string2 = string;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return string2;
    }
}

