/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.impl.pipeline.DefaultPipeFactory;
import org.jboss.aerogear.android.impl.pipeline.LoaderAdapter;
import org.jboss.aerogear.android.impl.pipeline.PipeConfig;
import org.jboss.aerogear.android.impl.pipeline.SupportLoaderAdapter;
import org.jboss.aerogear.android.pipeline.LoaderPipe;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeFactory;

public class Pipeline {
    private final URL baseURL;
    private final Map<String, Pipe> pipes = new HashMap<String, Pipe>();
    private final Multimap<String, Integer> loaderIdsForNamed = HashMultimap.create();
    private final PipeFactory pipeFactory;

    public Pipeline(URL baseURL) {
        this.baseURL = baseURL;
        this.pipeFactory = new DefaultPipeFactory();
    }

    public Pipeline(URL baseURL, PipeFactory pipeFactory) {
        this.baseURL = baseURL;
        this.pipeFactory = pipeFactory;
    }

    public Pipeline(String baseURL) {
        this(baseURL, (PipeFactory)new DefaultPipeFactory());
    }

    private Pipeline(String baseURL, PipeFactory pipeFactory) {
        this.pipeFactory = pipeFactory;
        try {
            this.baseURL = new URL(baseURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Pipe pipe(Class klass) {
        PipeConfig config = new PipeConfig(this.baseURL, klass);
        return this.pipe(klass, config);
    }

    public Pipe pipe(Class klass, PipeConfig config) {
        Pipe pipe = this.pipeFactory.createPipe(klass, config);
        this.pipes.put(config.getName(), pipe);
        return pipe;
    }

    public Pipe remove(String name) {
        return this.pipes.remove(name);
    }

    public Pipe get(String name) {
        return this.pipes.get(name);
    }

    public LoaderPipe get(String name, Activity activity) {
        Pipe pipe = this.pipes.get(name);
        LoaderAdapter adapter = new LoaderAdapter(activity, pipe, name);
        adapter.setLoaderIds(this.loaderIdsForNamed);
        return adapter;
    }

    public LoaderPipe get(String name, Fragment fragment, Context applicationContext) {
        Pipe pipe = this.pipes.get(name);
        LoaderAdapter adapter = new LoaderAdapter(fragment, applicationContext, pipe, name);
        adapter.setLoaderIds(this.loaderIdsForNamed);
        return adapter;
    }

    public LoaderPipe get(String name, FragmentActivity activity) {
        Pipe pipe = this.pipes.get(name);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(activity, pipe, name);
        adapter.setLoaderIds(this.loaderIdsForNamed);
        return adapter;
    }

    public LoaderPipe get(String name, android.support.v4.app.Fragment fragment, Context applicationContext) {
        Pipe pipe = this.pipes.get(name);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(fragment, applicationContext, pipe, name);
        adapter.setLoaderIds(this.loaderIdsForNamed);
        return adapter;
    }
}

