/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader.support;

import android.content.Context;
import android.util.Log;
import java.util.concurrent.CountDownLatch;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.support.AbstractSupportAuthenticationLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;

public class SupportLoginLoader
extends AbstractSupportAuthenticationLoader {
    private static final String TAG = SupportLoginLoader.class.getSimpleName();
    private HeaderAndBody result = null;
    private final String username;
    private final String password;

    public SupportLoginLoader(Context context, Callback callback, AuthenticationModule module, String username, String password) {
        super(context, module, callback);
        this.username = username;
        this.password = password;
    }

    public HeaderAndBody loadInBackground() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.module.login(this.username, this.password, new Callback<HeaderAndBody>(){

            @Override
            public void onSuccess(HeaderAndBody data) {
                SupportLoginLoader.this.result = data;
                latch.countDown();
            }

            @Override
            public void onFailure(Exception e) {
                SupportLoginLoader.super.setException(e);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
        return this.result;
    }

    protected void onStartLoading() {
        if (!this.module.isLoggedIn() && this.result == null) {
            this.forceLoad();
        } else {
            this.deliverResult(this.result);
        }
    }
}

