/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline.paging;

import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.pipeline.paging.URIPageHeaderParser;
import org.jboss.aerogear.android.pipeline.paging.PageConfig;
import org.jboss.aerogear.android.pipeline.paging.PageParameterExtractor;

public class URIBodyPageParser
implements PageParameterExtractor<PageConfig> {
    private final URI baseUri;
    private static final String TAG = URIPageHeaderParser.class.getSimpleName();

    public URIBodyPageParser(URI uri) {
        this.baseUri = uri;
    }

    public URIBodyPageParser(URL url) {
        try {
            this.baseUri = url.toURI();
        }
        catch (URISyntaxException ex) {
            Log.e((String)TAG, (String)(url + " could not become URI"), (Throwable)ex);
            throw new RuntimeException(url + " could not become URI", ex);
        }
    }

    public URIBodyPageParser() {
        this.baseUri = null;
    }

    @Override
    public ReadFilter getNextFilter(HeaderAndBody result, PageConfig config) {
        ReadFilter filter = new ReadFilter();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(new String(result.getBody()));
        URI nextUri = URI.create(this.getFromJSON(element, config.getNextIdentifier()));
        filter.setLinkUri(this.baseUri.resolve(nextUri));
        return filter;
    }

    @Override
    public ReadFilter getPreviousFilter(HeaderAndBody result, PageConfig config) {
        ReadFilter filter = new ReadFilter();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(new String(result.getBody()));
        URI nextUri = URI.create(this.getFromJSON(element, config.getPreviousIdentifier()));
        filter.setLinkUri(this.baseUri.resolve(nextUri));
        return filter;
    }

    private String getFromJSON(JsonElement element, String nextIdentifier) {
        String[] identifiers;
        for (String identifier : identifiers = nextIdentifier.split("\\.")) {
            element = element.getAsJsonObject().get(identifier);
        }
        if (element.isJsonNull()) {
            return null;
        }
        return element.getAsString();
    }
}

