/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.Context;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.support.v4.content.ModernAsyncTask;
import android.support.v4.util.TimeUtils;
import com.xtremelabs.robolectric.bytecode.RobolectricInternals;
import java.io.FileDescriptor;
import java.io.PrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class AsyncTaskLoader<D>
extends Loader<D> {
    static final String TAG = "AsyncTaskLoader";
    static final boolean DEBUG = false;
    volatile LoadTask mTask;
    volatile LoadTask mCancellingTask;
    long mUpdateThrottle;
    long mLastLoadCompleteTime;
    Handler mHandler;
    public Object __shadow__;

    public AsyncTaskLoader(Context context) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"<init>", (Object)this, (String[])new String[]{"android.content.Context"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)context)});
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public void setUpdateThrottle(long delayMS) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"setUpdateThrottle", (Object)this, (String[])new String[]{"long"}, (Object[])new Object[]{RobolectricInternals.autobox((long)delayMS)});
            } else {
                this.mUpdateThrottle = delayMS;
                if (delayMS != 0L) {
                    this.mHandler = new Handler();
                }
            }
        }
        finally {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    protected void onForceLoad() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"onForceLoad", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                super.onForceLoad();
                this.cancelLoad();
                this.mTask = new LoadTask(this);
                this.executePendingTask();
            }
        }
        finally {
            Object var2_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public boolean cancelLoad() {
        boolean bl;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"cancelLoad", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                bl = object != null ? (Boolean)object : false;
            } else if (this.mTask != null) {
                if (this.mCancellingTask != null) {
                    if (this.mTask.waiting) {
                        this.mTask.waiting = false;
                        this.mHandler.removeCallbacks((Runnable)this.mTask);
                    }
                    this.mTask = null;
                    bl = false;
                } else if (this.mTask.waiting) {
                    this.mTask.waiting = false;
                    this.mHandler.removeCallbacks((Runnable)this.mTask);
                    this.mTask = null;
                    bl = false;
                } else {
                    boolean cancelled = this.mTask.cancel(false);
                    if (cancelled) {
                        this.mCancellingTask = this.mTask;
                    }
                    this.mTask = null;
                    bl = cancelled;
                }
            } else {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    public void onCanceled(D data) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"onCanceled", (Object)this, (String[])new String[]{"java.lang.Object"}, (Object[])new Object[]{RobolectricInternals.autobox(data)});
            }
        }
        finally {
            Object var3_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void executePendingTask() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"executePendingTask", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else if (this.mCancellingTask == null && this.mTask != null) {
                long now;
                if (this.mTask.waiting) {
                    this.mTask.waiting = false;
                    this.mHandler.removeCallbacks((Runnable)this.mTask);
                }
                if (this.mUpdateThrottle > 0L && (now = SystemClock.uptimeMillis()) < this.mLastLoadCompleteTime + this.mUpdateThrottle) {
                    this.mTask.waiting = true;
                    this.mHandler.postAtTime((Runnable)this.mTask, this.mLastLoadCompleteTime + this.mUpdateThrottle);
                } else {
                    this.mTask.executeOnExecutor(ModernAsyncTask.THREAD_POOL_EXECUTOR, (Object[])null);
                }
            }
        }
        finally {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void dispatchOnCancelled(LoadTask task, D data) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"dispatchOnCancelled", (Object)this, (String[])new String[]{"android.support.v4.content.AsyncTaskLoader$LoadTask", "java.lang.Object"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)task), RobolectricInternals.autobox(data)});
            } else {
                this.onCanceled(data);
                if (this.mCancellingTask == task) {
                    this.rollbackContentChanged();
                    this.mLastLoadCompleteTime = SystemClock.uptimeMillis();
                    this.mCancellingTask = null;
                    this.executePendingTask();
                }
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    void dispatchOnLoadComplete(LoadTask task, D data) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"dispatchOnLoadComplete", (Object)this, (String[])new String[]{"android.support.v4.content.AsyncTaskLoader$LoadTask", "java.lang.Object"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)task), RobolectricInternals.autobox(data)});
            } else if (this.mTask != task) {
                this.dispatchOnCancelled(task, data);
            } else if (this.isAbandoned()) {
                this.onCanceled(data);
            } else {
                this.commitContentChanged();
                this.mLastLoadCompleteTime = SystemClock.uptimeMillis();
                this.mTask = null;
                this.deliverResult(data);
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public D loadInBackground() {
        D d;
        try {
            d = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        D d2 = d;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return d2;
    }

    protected D onLoadInBackground() {
        Object object;
        try {
            Object object2;
            object = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"onLoadInBackground", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? object2 : null) : this.loadInBackground();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        D d = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return d;
    }

    public void waitForLoader() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"waitForLoader", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            } else {
                LoadTask task = this.mTask;
                if (task != null) {
                    try {
                        LoadTask.access$000((LoadTask)task).await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            Object var4_5 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"dump", (Object)this, (String[])new String[]{"java.lang.String", "java.io.FileDescriptor", "java.io.PrintWriter", "java.lang.String[]"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)prefix), RobolectricInternals.autobox((Object)fd), RobolectricInternals.autobox((Object)writer), RobolectricInternals.autobox((Object)args)});
            } else {
                super.dump(prefix, fd, writer, args);
                if (this.mTask != null) {
                    writer.print(prefix);
                    writer.print("mTask=");
                    writer.print(this.mTask);
                    writer.print(" waiting=");
                    writer.println(this.mTask.waiting);
                }
                if (this.mCancellingTask != null) {
                    writer.print(prefix);
                    writer.print("mCancellingTask=");
                    writer.print(this.mCancellingTask);
                    writer.print(" waiting=");
                    writer.println(this.mCancellingTask.waiting);
                }
                if (this.mUpdateThrottle != 0L) {
                    writer.print(prefix);
                    writer.print("mUpdateThrottle=");
                    TimeUtils.formatDuration((long)this.mUpdateThrottle, (PrintWriter)writer);
                    writer.print(" mLastLoadCompleteTime=");
                    TimeUtils.formatDuration((long)this.mLastLoadCompleteTime, (long)SystemClock.uptimeMillis(), (PrintWriter)writer);
                    writer.println();
                }
            }
        }
        finally {
            Object var6_7 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public AsyncTaskLoader() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"<init>", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            }
        }
        finally {
            Object var2_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        try {
            Object object2;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"equals", (Object)this, (String[])new String[]{"java.lang.Object"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)object)})) != null ? ((Boolean)object2).booleanValue() : super.equals(object)) : super.equals(object);
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    @Override
    public int hashCode() {
        int n;
        try {
            Object object;
            n = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"hashCode", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? ((Integer)object).intValue() : super.hashCode()) : 0;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    @Override
    public String toString() {
        String string;
        try {
            Object object;
            string = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(AsyncTaskLoader.class, (String)"toString", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (String)object : super.toString()) : super.toString();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        String string2 = string;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return string2;
    }
}

