/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.core.HttpProviderFactory;
import org.jboss.aerogear.android.impl.util.UrlUtils;

public abstract class AbstractAuthenticationModuleRunner {
    private static final String TAG = AbstractAuthenticationModuleRunner.class.getSimpleName();
    protected final URL baseURL;
    protected final String enrollEndpoint;
    protected final URL enrollURL;
    protected final Provider<HttpProvider> httpProviderFactory = new HttpProviderFactory();
    protected final String loginEndpoint;
    protected final URL loginURL;
    protected final String logoutEndpoint;
    protected final URL logoutURL;
    protected final Integer timeout;

    public AbstractAuthenticationModuleRunner(URL baseURL, AuthenticationConfig config) {
        this.baseURL = baseURL;
        this.loginEndpoint = config.getLoginEndpoint();
        this.logoutEndpoint = config.getLogoutEndpoint();
        this.enrollEndpoint = config.getEnrollEndpoint();
        this.loginURL = UrlUtils.appendToBaseURL(baseURL, this.loginEndpoint);
        this.logoutURL = UrlUtils.appendToBaseURL(baseURL, this.logoutEndpoint);
        this.enrollURL = UrlUtils.appendToBaseURL(baseURL, this.enrollEndpoint);
        this.timeout = config.getTimeout();
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public URI getBaseURI() {
        try {
            return this.baseURL.toURI();
        }
        catch (URISyntaxException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getEnrollEndpoint() {
        return this.enrollEndpoint;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    abstract HeaderAndBody onEnroll(Map<String, String> var1);

    abstract HeaderAndBody onLogin(String var1, String var2);

    abstract void onLogout();
}

