/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import com.google.common.base.Strings;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.authentication.impl.AbstractAuthenticationModuleRunner;
import org.jboss.aerogear.android.authentication.impl.DigestHeaderUtils;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.json.JSONObject;

public class DigestAuthenticationModuleRunner
extends AbstractAuthenticationModuleRunner {
    private final String TAG = DigestAuthenticationModuleRunner.class.getSimpleName();
    private static String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String REALM = "realm";
    private static final String DOMAIN = "domain";
    private static final String NONCE = "nonce";
    private static final String STALE = "stale";
    private static final String ALGORITHM = "algorithm";
    private static final String QOP_OPTIONS = "qop";
    private static final String OPAQUE = "opaque";
    private String cnonce = UUID.randomUUID().toString();
    private int nonce_count = 0;
    private String nonce;
    private String qop;
    private String realm;
    private String domain;
    private String algorithm;
    private String stale;
    private String opaque;
    private String username;
    private String password;

    public DigestAuthenticationModuleRunner(URL baseURL, AuthenticationConfig config) {
        super(baseURL, config);
    }

    @Override
    public HeaderAndBody onEnroll(Map<String, String> userData) {
        HttpProvider provider = (HttpProvider)this.httpProviderFactory.get(this.enrollURL, this.timeout);
        String enrollData = new JSONObject(userData).toString();
        return provider.post(enrollData);
    }

    @Override
    public HeaderAndBody onLogin(String username, String password) {
        HttpProvider provider = (HttpProvider)this.httpProviderFactory.get(this.loginURL, this.timeout);
        try {
            provider.get();
            throw new IllegalStateException("Login Called on service which was already logged in.");
        }
        catch (HttpException exception) {
            if (exception.getStatusCode() != 401) {
                throw exception;
            }
            Map<String, String> authenticateHeaders = DigestHeaderUtils.extractValues(exception.getHeaders().get(WWW_AUTHENTICATE_HEADER));
            this.realm = authenticateHeaders.get(REALM);
            this.domain = authenticateHeaders.get(DOMAIN);
            this.nonce = authenticateHeaders.get(NONCE);
            this.algorithm = authenticateHeaders.get(ALGORITHM);
            this.qop = authenticateHeaders.get(QOP_OPTIONS);
            this.stale = authenticateHeaders.get(STALE);
            this.opaque = authenticateHeaders.get(OPAQUE);
            this.username = username;
            this.password = password;
            this.checkQop(this.qop);
            this.checkAlgorithm(this.algorithm);
            try {
                provider.setDefaultHeader("Authorization", this.getAuthorizationHeader(this.loginURL.toURI(), "GET", new byte[0]));
            }
            catch (URISyntaxException ex) {
                Log.e((String)this.TAG, (String)ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
            return provider.get();
        }
    }

    @Override
    public void onLogout() {
        HttpProvider provider = (HttpProvider)this.httpProviderFactory.get(this.logoutURL, this.timeout);
        this.clear();
        CookieStore store = ((CookieManager)CookieManager.getDefault()).getCookieStore();
        List<HttpCookie> cookies = store.get(this.getBaseURI());
        for (HttpCookie cookie : cookies) {
            store.remove(this.getBaseURI(), cookie);
        }
        provider.post("");
    }

    private void clear() {
        this.realm = null;
        this.domain = null;
        this.nonce = null;
        this.algorithm = null;
        this.qop = null;
        this.stale = null;
        this.opaque = null;
        this.username = null;
        this.password = null;
    }

    private void checkQop(String qop) {
        if (qop == null) {
            return;
        }
        for (String option : qop.split(",")) {
            if (!"auth".equals(option)) continue;
            this.qop = "auth";
            return;
        }
        throw new IllegalArgumentException(String.format("%s is not a supported qop type.", qop));
    }

    public String getAuthorizationHeader(URI uri, String method, byte[] entityBody) {
        String digestResponse;
        ++this.nonce_count;
        StringBuilder sb = new StringBuilder();
        String HA1 = this.calculateHA1();
        String HA2 = this.calculateHA2(method, uri, entityBody);
        if (this.qop == null) {
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(HA1).append(":").append(this.nonce).append(":").append(HA2);
            digestResponse = DigestHeaderUtils.computeMD5Hash(responseBuilder.toString().getBytes());
        } else {
            StringBuilder responseBuilder = new StringBuilder();
            responseBuilder.append(HA1).append(":").append(this.nonce).append(":").append(this.nonce_count).append(":").append(this.cnonce).append(":").append(this.qop).append(":").append(HA2);
            digestResponse = DigestHeaderUtils.computeMD5Hash(responseBuilder.toString().getBytes());
        }
        sb.append("Digest ").append("username=\"").append(this.username).append('\"').append(",realm=\"").append(this.realm).append('\"').append(",nonce=\"").append(this.nonce).append('\"').append(",uri=\"").append(uri.toString()).append('\"').append(",response=\"").append(digestResponse).append('\"');
        if (!Strings.isNullOrEmpty((String)this.qop)) {
            sb.append(",qop=").append(this.qop).append(",nc=").append(this.nonce_count).append(",cnonce=\"").append(this.cnonce).append('\"').append(",opaque=\"").append(this.opaque).append('\"');
        }
        return sb.toString();
    }

    private void checkAlgorithm(String algorithm) {
        if (algorithm == null) {
            return;
        }
        for (String option : algorithm.split(",")) {
            if (!"MD5".equals(option) && !"MD5-sess".equals(option)) continue;
            this.algorithm = option;
            return;
        }
        throw new IllegalArgumentException(String.format("%s is not a supported algorithm type.", algorithm));
    }

    private String calculateHA1() {
        StringBuilder a1Builder = new StringBuilder();
        a1Builder.append(this.username).append(":").append(this.realm).append(":").append(this.password);
        if ("MD5-sess".equals(this.algorithm)) {
            String tempA1 = DigestHeaderUtils.computeMD5Hash(a1Builder.toString().getBytes());
            a1Builder = new StringBuilder();
            a1Builder.append(tempA1).append(":").append(this.nonce).append(":").append(this.cnonce);
        }
        return DigestHeaderUtils.computeMD5Hash(a1Builder.toString().getBytes());
    }

    private String calculateHA2(String method, URI uri, byte[] entityBody) {
        StringBuilder a2Builder = new StringBuilder();
        if ("auth-int".equals(this.qop)) {
            a2Builder.append(method).append(":").append(uri).append(":").append(DigestHeaderUtils.computeMD5Hash(entityBody));
        } else {
            a2Builder.append(method).append(":").append(uri);
        }
        return DigestHeaderUtils.computeMD5Hash(a2Builder.toString().getBytes());
    }

    boolean retryLogin() {
        this.onLogin(this.username, this.password);
        return true;
    }
}

