/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android;

import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreFactory;
import org.jboss.aerogear.android.impl.datamanager.DefaultIdGenerator;
import org.jboss.aerogear.android.impl.datamanager.DefaultStoreFactory;
import org.jboss.aerogear.android.impl.datamanager.StoreConfig;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;

public class DataManager {
    private final Map<String, Store> stores = new HashMap<String, Store>();
    private final IdGenerator idGenerator;
    private final StoreFactory storeFactory;

    public DataManager() {
        this(new DefaultIdGenerator(), new DefaultStoreFactory());
    }

    public DataManager(IdGenerator idGenerator) {
        this(idGenerator, new DefaultStoreFactory());
    }

    public DataManager(StoreFactory storeFactory) {
        this(new DefaultIdGenerator(), storeFactory);
    }

    public DataManager(IdGenerator idGenerator, StoreFactory storeFactory) {
        if (idGenerator == null) {
            throw new IllegalArgumentException("Id Generator should not be null");
        }
        if (storeFactory == null) {
            throw new IllegalArgumentException("StoreFactory should not be null");
        }
        this.idGenerator = idGenerator;
        this.storeFactory = storeFactory;
    }

    public Store store(String storeName) {
        return this.store(storeName, new StoreConfig());
    }

    public Store store(String storeName, StoreConfig config) {
        Store store = this.storeFactory.createStore(config);
        this.stores.put(storeName, store);
        return store;
    }

    public Store encryptedStore(String storeName, String passphrase, Class modelClass) throws InvalidKeySpecException {
        StoreConfig config = new StoreConfig();
        config.setType(StoreTypes.ENCRYPTED_MEMORY);
        return this.encryptedStore(storeName, config, passphrase, modelClass);
    }

    public Store encryptedStore(String storeName, StoreConfig config, String passphrase, Class modelClass) throws InvalidKeySpecException {
        config.setPassphrase(passphrase);
        config.setKlass(modelClass);
        Store store = this.storeFactory.createStore(config);
        this.stores.put(storeName, store);
        return store;
    }

    public Store remove(String storeName) {
        return this.stores.remove(storeName);
    }

    public Store get(String storeName) {
        return this.stores.get(storeName);
    }
}

