/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android;

import android.content.Context;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.impl.security.DefaultEncryptionServiceFactory;
import org.jboss.aerogear.android.security.CryptoConfig;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.EncryptionServiceFactory;

public class KeyManager {
    private final EncryptionServiceFactory serviceFactory;
    private final Map<String, EncryptionService> services = new HashMap<String, EncryptionService>();

    public KeyManager(EncryptionServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public KeyManager() {
        this.serviceFactory = new DefaultEncryptionServiceFactory();
    }

    public EncryptionService encryptionService(String name, CryptoConfig config, Context context) {
        EncryptionService service = this.serviceFactory.getService(config, context);
        this.services.put(name, service);
        return service;
    }

    public EncryptionService get(String name) {
        return this.services.get(name);
    }

    public void remove(String name) {
        this.services.remove(name);
    }
}

