/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreType;
import org.jboss.aerogear.android.impl.crypto.InvalidKeyException;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.impl.reflection.Scan;
import org.jboss.aerogear.android.impl.util.CryptoUtils;
import org.jboss.aerogear.crypto.Random;
import org.jboss.aerogear.crypto.keys.PrivateKey;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class EncryptedSQLStore<T>
extends SQLiteOpenHelper
implements Store<T> {
    private final Class<T> modelClass;
    private final GsonBuilder builder;
    private final IdGenerator idGenerator;
    private final String passphrase;
    private CryptoUtils<T> cryptoUtils;
    private final String ENCRYPT_HELPER_TABLE_SUFIX = "_ENCRYPT_HELPER";
    private final String TABLE_NAME;
    private final String COLUMN_ID = "ID";
    private final String COLUMN_DATA = "DATA";
    private final String ID_IV = "IV";
    private final String ID_SALT = "SALT";

    public EncryptedSQLStore(Class<T> modelClass, Context context, GsonBuilder builder, IdGenerator idGenerator, String passphrase) {
        super(context, modelClass.getSimpleName(), null, 1);
        this.modelClass = modelClass;
        this.builder = builder;
        this.idGenerator = idGenerator;
        this.passphrase = passphrase;
        this.TABLE_NAME = modelClass.getSimpleName();
    }

    private String getEncryptTableHelperName() {
        return this.TABLE_NAME.toUpperCase() + "_ENCRYPT_HELPER";
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        byte[] salt = new Random().randomBytes();
        byte[] iv = new Random().randomBytes();
        String SQL_CREATE_ENCRYPT_HELPER_TABLE = "CREATE TABLE IF NOT EXISTS " + this.getEncryptTableHelperName() + " ( " + "ID" + " TEXT NOT NULL, " + "DATA" + " BLOB NOT NULL " + " ) ";
        sqLiteDatabase.execSQL(SQL_CREATE_ENCRYPT_HELPER_TABLE);
        String SQL_STORE_IV = "INSERT INTO " + this.getEncryptTableHelperName() + " ( " + "ID" + ", " + "DATA" + " ) " + " VALUES ( ?, ? ) ";
        sqLiteDatabase.execSQL(SQL_STORE_IV, new Object[]{"IV", iv});
        String SQL_STORE_SALT = "INSERT INTO " + this.getEncryptTableHelperName() + " ( " + "ID" + ", " + "DATA" + " ) " + " VALUES ( ?, ? ) ";
        sqLiteDatabase.execSQL(SQL_STORE_SALT, new Object[]{"SALT", salt});
        String SQL_CREATE_ENTITY_TABLE = "CREATE TABLE IF NOT EXISTS " + this.TABLE_NAME + " ( " + "ID" + " TEXT NOT NULL, " + "DATA" + " BLOB NOT NULL " + " ) ";
        sqLiteDatabase.execSQL(SQL_CREATE_ENTITY_TABLE);
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(SQLiteDatabase db) {
        byte[] salt;
        byte[] iv;
        super.onOpen(db);
        String SQL = "SELECT DATA FROM " + this.getEncryptTableHelperName() + " WHERE " + "ID" + " = ?";
        Cursor cursorIV = db.rawQuery(SQL, new String[]{"IV"});
        cursorIV.moveToFirst();
        try {
            iv = cursorIV.getBlob(0);
        }
        finally {
            cursorIV.close();
        }
        Cursor cursorSalt = db.rawQuery(SQL, new String[]{"SALT"});
        cursorSalt.moveToFirst();
        try {
            salt = cursorSalt.getBlob(0);
        }
        finally {
            cursorSalt.close();
        }
        try {
            Pbkdf2 pbkdf2 = AeroGearCrypto.pbkdf2();
            byte[] rawPassword = pbkdf2.encrypt(this.passphrase, salt);
            PrivateKey privateKey = new PrivateKey(rawPassword);
            this.cryptoUtils = new CryptoUtils<T>(privateKey, iv, this.modelClass, this.builder);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
    }

    @Override
    public StoreType getType() {
        return StoreTypes.ENCRYPTED_SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> readAll() throws InvalidKeyException {
        ArrayList<T> dataList = new ArrayList<T>();
        String sql = "SELECT DATA FROM " + this.TABLE_NAME;
        Cursor cursor = this.getReadableDatabase().rawQuery(sql, new String[0]);
        try {
            while (cursor.moveToNext()) {
                byte[] encryptedData = cursor.getBlob(0);
                T decryptedData = this.cryptoUtils.decrypt(encryptedData);
                dataList.add(decryptedData);
            }
        }
        finally {
            cursor.close();
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Serializable id) throws InvalidKeyException {
        String sql = "SELECT DATA FROM " + this.TABLE_NAME + " WHERE " + "ID" + " = ?";
        Cursor cursor = this.getReadableDatabase().rawQuery(sql, new String[]{id.toString()});
        cursor.moveToFirst();
        if (cursor.getCount() == 0) {
            return null;
        }
        try {
            byte[] encryptedData = cursor.getBlob(0);
            T t = this.cryptoUtils.decrypt(encryptedData);
            return t;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(T item) {
        String recordIdFieldName = Scan.recordIdFieldNameIn(item.getClass());
        Property property = new Property(item.getClass(), recordIdFieldName);
        Serializable idValue = (Serializable)property.getValue(item);
        if (idValue == null) {
            idValue = this.idGenerator.generate();
            property.setValue(item, idValue);
        }
        ContentValues values = new ContentValues();
        values.put("ID", idValue.toString());
        values.put("DATA", this.cryptoUtils.encrypt(item));
        this.getWritableDatabase().insert(this.TABLE_NAME, null, values);
    }

    @Override
    public void reset() {
        String sql = String.format("DELETE FROM " + this.TABLE_NAME, new Object[0]);
        this.getWritableDatabase().execSQL(sql);
    }

    @Override
    public void remove(Serializable id) {
        String sql = "DELETE FROM " + this.TABLE_NAME + " WHERE " + "ID" + " = ?";
        this.getWritableDatabase().execSQL(sql, new Object[]{id});
    }

    @Override
    public boolean isEmpty() {
        String sql = "SELECT COUNT(ID) FROM " + this.TABLE_NAME;
        Cursor cursor = this.getReadableDatabase().rawQuery(sql, null);
        cursor.moveToFirst();
        boolean result = cursor.getInt(0) == 0;
        cursor.close();
        return result;
    }
}

