/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.security;

import android.content.Context;
import android.util.Log;
import java.security.spec.InvalidKeySpecException;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.android.impl.security.AbstractEncryptionService;
import org.jboss.aerogear.android.impl.security.EncryptionServiceTypes;
import org.jboss.aerogear.android.security.CryptoConfig;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.EncryptionServiceType;
import org.jboss.aerogear.crypto.CryptoBox;
import org.jboss.aerogear.crypto.Random;
import org.jboss.aerogear.crypto.keys.PrivateKey;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class PassphraseEncryptionServices
extends AbstractEncryptionService
implements EncryptionService {
    private static final String TAG = PassphraseEncryptionServices.class.getSimpleName();
    private final CryptoBox crypto;

    public PassphraseEncryptionServices(Context appContext, PassPhraseCryptoConfig config) {
        super(appContext);
        this.crypto = this.getCrypto(config);
    }

    private CryptoBox getCrypto(PassPhraseCryptoConfig config) {
        Pbkdf2 pbkdf2 = AeroGearCrypto.pbkdf2();
        this.validate(config);
        try {
            byte[] rawPassword = pbkdf2.encrypt(config.passphrase, config.salt);
            return new CryptoBox(new PrivateKey(rawPassword));
        }
        catch (InvalidKeySpecException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private void validate(PassPhraseCryptoConfig config) {
        if (config.salt == null) {
            throw new IllegalArgumentException("The salt must not be null");
        }
        if (config.passphrase == null) {
            throw new IllegalArgumentException("The passphrase must not be null");
        }
    }

    @Override
    protected CryptoBox getCryptoInstance() {
        return this.crypto;
    }

    public static class PassPhraseCryptoConfig
    implements CryptoConfig {
        private byte[] salt = new Random().randomBytes();
        private String passphrase;

        public byte[] getSalt() {
            return this.salt;
        }

        public void setSalt(byte[] salt) {
            this.salt = salt;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }

        @Override
        public EncryptionServiceType getType() {
            return EncryptionServiceTypes.PASSPHRASE;
        }
    }
}

