/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.authorization.AuthzModule;
import org.jboss.aerogear.android.impl.authz.AuthzConfig;
import org.jboss.aerogear.android.impl.authz.AuthzTypes;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzModule;

public class Authorizer {
    private final Map<String, AuthzModule> modules = new HashMap<String, AuthzModule>();

    public AuthzModule authz(AuthzConfig config) {
        if (!AuthzTypes.OAUTH2.equals(config.getType())) {
            throw new IllegalArgumentException(config.getType().getName() + " is not supported");
        }
        this.modules.put(config.getName(), new OAuth2AuthzModule(config));
        return this.modules.get(config.getName());
    }

    public AuthzModule remove(String moduleName) {
        return this.modules.remove(moduleName);
    }

    public AuthzModule get(String moduleName) {
        return this.modules.get(moduleName);
    }
}

