/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.AGSecurityAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.AuthTypes;
import org.jboss.aerogear.android.authentication.impl.HttpBasicAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.HttpDigestAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.AuthenticationModuleAdapter;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportAuthenticationModuleAdapter;

public class Authenticator {
    private final Map<String, AuthenticationModule> modules = new HashMap<String, AuthenticationModule>();
    private final URL baseURL;

    public Authenticator(URL baseURL) {
        this.baseURL = baseURL;
    }

    public Authenticator(String baseURL) {
        try {
            this.baseURL = new URL(baseURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public AuthenticationModule remove(String name) {
        return this.modules.remove(name);
    }

    public AuthenticationModule auth(String name, AuthenticationConfig config) {
        AuthTypes type = AuthTypes.valueOf(config.getAuthType());
        if (type == null) {
            throw new IllegalArgumentException("Unsupported Auth Type passed");
        }
        switch (type) {
            case AG_SECURITY: {
                this.modules.put(name, new AGSecurityAuthenticationModule(this.baseURL, config));
                break;
            }
            case HTTP_BASIC: {
                this.modules.put(name, new HttpBasicAuthenticationModule(this.baseURL));
                break;
            }
            case HTTP_DIGEST: {
                this.modules.put(name, new HttpDigestAuthenticationModule(this.baseURL, config));
                break;
            }
        }
        return this.modules.get(name);
    }

    public void add(String name, AuthenticationModule module) {
        this.modules.put(name, module);
    }

    public AuthenticationModule get(String name) {
        return this.modules.get(name);
    }

    public AuthenticationModule get(String name, Activity activity) {
        return new AuthenticationModuleAdapter(activity, this.modules.get(name), name);
    }

    public AuthenticationModule get(String name, Fragment fragment, Context applicationContext) {
        return new AuthenticationModuleAdapter(fragment, applicationContext, this.modules.get(name), name);
    }

    public AuthenticationModule get(String name, FragmentActivity activity) {
        return new SupportAuthenticationModuleAdapter(activity, this.modules.get(name), name);
    }

    public AuthenticationModule get(String name, android.support.v4.app.Fragment fragment, Context applicationContext) {
        return new SupportAuthenticationModuleAdapter(fragment, applicationContext, this.modules.get(name), name);
    }
}

