/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public final class DigestHeaderUtils {
    private static final String TAG = DigestHeaderUtils.class.getSimpleName();
    private static final String DIGEST = "Digest";
    private static final String WHITESPACE = "\\s";
    private static final String COMMA = ",";
    private static final String QUOTE = "\"";
    private static final String EQ = "=";

    public static Map<String, String> extractValues(String authenticateHeader) {
        States state = States.DIGEST;
        StringBuilder word = new StringBuilder();
        String key = "";
        String value = "";
        String valueTerminator = COMMA;
        HashMap<String, String> values = new HashMap<String, String>();
        if (!(authenticateHeader = authenticateHeader.trim()).startsWith(DIGEST)) {
            throw new IllegalArgumentException(authenticateHeader + " Did not begin with the Digest challenge string.");
        }
        char[] arr$ = authenticateHeader.toCharArray();
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            Character character = Character.valueOf(arr$[i$]);
            if (DigestHeaderUtils.matches(character, WHITESPACE)) continue;
            switch (state) {
                case DIGEST: {
                    word.append(character);
                    if (word.lastIndexOf(DIGEST) == -1) continue block5;
                    word = new StringBuilder();
                    state = States.KEY;
                    continue block5;
                }
                case KEY: {
                    if (DigestHeaderUtils.matches(character, EQ)) {
                        key = word.toString();
                        word = new StringBuilder();
                        state = States.VALUE;
                        continue block5;
                    }
                    if (DigestHeaderUtils.matches(character, COMMA)) continue block5;
                    word.append(character);
                    continue block5;
                }
                case VALUE: {
                    if (DigestHeaderUtils.matches(character, valueTerminator)) {
                        value = word.toString();
                        word = new StringBuilder();
                        valueTerminator = COMMA;
                        values.put(key, value);
                        state = States.KEY;
                        continue block5;
                    }
                    if (DigestHeaderUtils.matches(character, QUOTE)) {
                        valueTerminator = QUOTE;
                        continue block5;
                    }
                    word.append(character);
                }
            }
        }
        return values;
    }

    private static boolean matches(Character character, String regex) {
        String str = character.toString();
        return str.matches(regex);
    }

    public static String computeMD5Hash(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bytes);
            byte[] messageDigest = digest.digest();
            StringBuilder md5Hash = new StringBuilder();
            for (int i = 0; i < messageDigest.length; ++i) {
                String hexChar = Integer.toHexString(0xFF & messageDigest[i]);
                while (hexChar.length() < 2) {
                    hexChar = "0" + hexChar;
                }
                md5Hash.append(hexChar);
            }
            return md5Hash.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static enum States {
        DIGEST,
        KEY,
        VALUE;

    }
}

