/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import android.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.authz.AuthzConfig;
import org.jboss.aerogear.android.impl.authz.OAuth2AuthorizationException;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.impl.datamanager.MemoryStorage;
import org.jboss.aerogear.android.impl.http.HttpRestProvider;
import org.jboss.aerogear.android.impl.util.UrlUtils;

public class AuthzService
extends Service {
    private final AuthzBinder binder = new AuthzBinder(this);
    private MemoryStorage<OAuth2AuthzSession> sessionStore;

    public void onCreate() {
        super.onCreate();
    }

    public String fetchAccessToken(String accountId, AuthzConfig config) throws OAuth2AuthorizationException {
        OAuth2AuthzSession storedAccount = this.sessionStore.read((Serializable)((Object)accountId));
        if (storedAccount == null) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)storedAccount.getAccessToken()) && storedAccount.tokenIsNotExpired()) {
            return storedAccount.getAccessToken();
        }
        if (!Strings.isNullOrEmpty((String)storedAccount.getRefreshToken())) {
            this.refreshAccount(storedAccount, config);
            this.sessionStore.save(storedAccount);
            return storedAccount.getAccessToken();
        }
        if (!Strings.isNullOrEmpty((String)storedAccount.getAuthorizationCode())) {
            this.exchangeAuthorizationCodeForAccessToken(storedAccount, config);
            this.sessionStore.save(storedAccount);
            return storedAccount.getAccessToken();
        }
        return null;
    }

    public void addAccount(OAuth2AuthzSession account) {
        String accountId = account.getAccountId();
        if (this.hasAccount(accountId)) {
            this.sessionStore.remove((Serializable)((Object)accountId));
        }
        this.sessionStore.save(account);
    }

    public boolean hasAccount(String accountId) {
        OAuth2AuthzSession storedAccount = this.sessionStore.read((Serializable)((Object)accountId));
        if (storedAccount == null) {
            return false;
        }
        return !Strings.isNullOrEmpty((String)storedAccount.getAuthorizationCode()) || !Strings.isNullOrEmpty((String)storedAccount.getAccessToken());
    }

    public OAuth2AuthzSession getAccount(String accountId) {
        return this.sessionStore.read((Serializable)((Object)accountId));
    }

    public List<String> getAccounts() {
        return new ArrayList<String>(Collections2.transform(this.sessionStore.readAll(), (Function)new Function<OAuth2AuthzSession, String>(){

            public String apply(OAuth2AuthzSession input) {
                return input.getAccountId();
            }
        }));
    }

    public IBinder onBind(Intent intent) {
        this.openSessionStore();
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    private void openSessionStore() {
        this.sessionStore = new MemoryStorage(new IdGenerator(){

            @Override
            public Serializable generate() {
                return UUID.randomUUID().toString();
            }
        });
    }

    private void exchangeAuthorizationCodeForAccessToken(OAuth2AuthzSession storedAccount, AuthzConfig config) throws OAuth2AuthorizationException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("code", storedAccount.getAuthorizationCode());
        data.put("client_id", storedAccount.getCliendId());
        if (config.getRedirectURL() != null) {
            data.put("redirect_uri", config.getRedirectURL());
        }
        data.put("grant_type", "authorization_code");
        if (config.getClientSecret() != null) {
            data.put("client_secret", config.getClientSecret());
        }
        if (!config.getAdditionalAccessParams().isEmpty()) {
            for (Pair<String, String> param : config.getAdditionalAccessParams()) {
                try {
                    data.put(URLEncoder.encode((String)param.first, "UTF-8"), (String)param.second);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.runAccountAction(storedAccount, config, data);
    }

    private void refreshAccount(OAuth2AuthzSession storedAccount, AuthzConfig config) throws OAuth2AuthorizationException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("refresh_token", storedAccount.getRefreshToken());
        data.put("grant_type", "refresh_token");
        data.put("client_id", storedAccount.getCliendId());
        if (config.getClientSecret() != null) {
            data.put("client_secret", config.getClientSecret());
        }
        if (!config.getAdditionalAccessParams().isEmpty()) {
            for (Pair<String, String> param : config.getAdditionalAccessParams()) {
                try {
                    data.put(URLEncoder.encode((String)param.first, "UTF-8"), (String)param.second);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.runAccountAction(storedAccount, config, data);
    }

    private void runAccountAction(OAuth2AuthzSession storedAccount, AuthzConfig config, Map<String, String> data) throws OAuth2AuthorizationException {
        try {
            String refreshToken;
            HeaderAndBody headerAndBody;
            URL accessTokenEndpoint = UrlUtils.appendToBaseURL(config.getBaseURL(), config.getAccessTokenEndpoint());
            HttpProvider provider = this.getHttpProvider(accessTokenEndpoint);
            String formTemplate = "%s=%s";
            provider.setDefaultHeader("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder bodyBuilder = new StringBuilder();
            String amp = "";
            for (Map.Entry<String, String> entry : data.entrySet()) {
                bodyBuilder.append(amp);
                try {
                    bodyBuilder.append(String.format("%s=%s", entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                amp = "&";
            }
            try {
                headerAndBody = provider.post(bodyBuilder.toString().getBytes("UTF-8"));
            }
            catch (HttpException exception) {
                if (exception.getStatusCode() == 400) {
                    JsonElement response = new JsonParser().parse(new String(exception.getData()));
                    JsonObject jsonResponseObject = response.getAsJsonObject();
                    String error = "";
                    if (jsonResponseObject.has("error")) {
                        error = jsonResponseObject.get("error").getAsString();
                    }
                    throw new OAuth2AuthorizationException(error);
                }
                throw exception;
            }
            JsonElement response = new JsonParser().parse(new String(headerAndBody.getBody()));
            JsonObject jsonResponseObject = response.getAsJsonObject();
            String accessToken = jsonResponseObject.get("access_token").getAsString();
            storedAccount.setAccessToken(accessToken);
            if (jsonResponseObject.has("expires_in")) {
                Long expiresIn = jsonResponseObject.get("expires_in").getAsLong();
                Long expires_on = new Date().getTime() + expiresIn * 1000L;
                storedAccount.setExpires_on(expires_on);
            }
            if (jsonResponseObject.has("refresh_token") && !Strings.isNullOrEmpty((String)(refreshToken = jsonResponseObject.get("refresh_token").getAsString()))) {
                storedAccount.setRefreshToken(refreshToken);
            }
            storedAccount.setAuthorizationCode("");
        }
        catch (UnsupportedEncodingException ex) {
            Log.d((String)AuthzService.class.getName(), null, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected HttpProvider getHttpProvider(URL url) {
        return new HttpRestProvider(url);
    }

    public static class AGAuthzServiceConnection
    implements ServiceConnection {
        private AuthzService service;
        private boolean bound = false;

        public void onServiceConnected(ComponentName className, IBinder iBinder) {
            AuthzBinder binder = (AuthzBinder)iBinder;
            this.service = binder.service;
            this.bound = true;
        }

        public void onServiceDisconnected(ComponentName arg0) {
            this.bound = false;
        }

        public AuthzService getService() {
            return this.service;
        }

        public boolean isBound() {
            return this.bound;
        }
    }

    public static class AuthzBinder
    extends Binder {
        private final AuthzService service;

        private AuthzBinder(AuthzService service) {
            this.service = service;
        }

        public AuthzService getService() {
            return this.service;
        }
    }
}

