/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Date;
import java.util.Objects;
import org.jboss.aerogear.android.RecordId;

public class OAuth2AuthzSession
implements Parcelable {
    @RecordId
    private String accountId = "";
    private String cliendId = "";
    private String accessToken = "";
    private String authorizationCode = "";
    private String refreshToken = "";
    private long expires_on = 0L;
    public static final Parcelable.Creator<OAuth2AuthzSession> CREATOR = new Parcelable.Creator<OAuth2AuthzSession>(){

        public OAuth2AuthzSession createFromParcel(Parcel in) {
            return new OAuth2AuthzSession(in);
        }

        public OAuth2AuthzSession[] newArray(int size) {
            return new OAuth2AuthzSession[size];
        }
    };

    private OAuth2AuthzSession(Parcel in) {
        this.cliendId = in.readString();
        this.accessToken = in.readString();
        this.authorizationCode = in.readString();
        this.refreshToken = in.readString();
        this.accountId = in.readString();
        this.expires_on = in.readLong();
    }

    public OAuth2AuthzSession() {
    }

    public String getCliendId() {
        return this.cliendId;
    }

    public void setCliendId(String cliendId) {
        this.cliendId = cliendId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public long getExpires_on() {
        return this.expires_on;
    }

    public void setExpires_on(long expires_on) {
        this.expires_on = expires_on;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.cliendId);
        hash = 71 * hash + Objects.hashCode(this.accessToken);
        hash = 71 * hash + Objects.hashCode(this.authorizationCode);
        hash = 71 * hash + Objects.hashCode(this.refreshToken);
        hash = 71 * hash + Objects.hashCode(this.accountId);
        hash = 71 * hash + (int)(this.expires_on ^ this.expires_on >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2AuthzSession other = (OAuth2AuthzSession)obj;
        if (!Objects.equals(this.cliendId, other.cliendId)) {
            return false;
        }
        if (!Objects.equals(this.accessToken, other.accessToken)) {
            return false;
        }
        if (!Objects.equals(this.authorizationCode, other.authorizationCode)) {
            return false;
        }
        if (!Objects.equals(this.refreshToken, other.refreshToken)) {
            return false;
        }
        if (!Objects.equals(this.accountId, other.accountId)) {
            return false;
        }
        return this.expires_on == other.expires_on;
    }

    public String toString() {
        return "AuthzSession{cliendId=" + this.cliendId + ", accessToken=" + this.accessToken + ", authorizationCode=" + this.authorizationCode + ", refreshToken=" + this.refreshToken + ", accountId=" + this.accountId + ", expires_on=" + this.expires_on + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cliendId);
        dest.writeString(this.accessToken);
        dest.writeString(this.authorizationCode);
        dest.writeString(this.refreshToken);
        dest.writeString(this.accountId);
        dest.writeLong(this.expires_on);
    }

    public boolean tokenIsNotExpired() {
        if (this.expires_on == 0L) {
            return true;
        }
        return this.expires_on > new Date().getTime();
    }
}

