/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.impl.authz.AuthzConfig;
import org.jboss.aerogear.android.impl.authz.AuthzService;
import org.jboss.aerogear.android.impl.authz.OAuth2AuthorizationException;

public class OAuth2FetchAccess {
    private final AuthzService service;

    public OAuth2FetchAccess(AuthzService service) {
        this.service = service;
    }

    public void fetchAccessCode(final String accountId, final AuthzConfig config, final Callback<String> callback) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<Object, Void, Object>(){

                protected Object doInBackground(Object ... params) {
                    try {
                        return OAuth2FetchAccess.this.service.fetchAccessToken((String)params[0], (AuthzConfig)params[1]);
                    }
                    catch (OAuth2AuthorizationException ex) {
                        return ex;
                    }
                }

                protected void onPostExecute(Object result) {
                    if (result instanceof String || result == null) {
                        callback.onSuccess((String)result);
                    } else {
                        callback.onFailure((Exception)result);
                    }
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[]{accountId, config});
        } else {
            new Handler(Looper.myLooper()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        String code = OAuth2FetchAccess.this.service.fetchAccessToken(accountId, config);
                        callback.onSuccess(code);
                    }
                    catch (OAuth2AuthorizationException ex) {
                        callback.onFailure(ex);
                    }
                }
            });
        }
    }
}

