/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.security;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import javax.crypto.spec.SecretKeySpec;

public class KeyStoreServices {
    private static final String TAG = KeyStoreServices.class.getSimpleName();
    private static final String DEFAULT_KEYSTORE = "default.keystore";
    private char[] password;
    private Context context;
    private KeyStore.PasswordProtection passwordProtectionParameter;
    private KeyStore store;

    public KeyStoreServices(Context context, char[] password) {
        try {
            this.passwordProtectionParameter = new KeyStore.PasswordProtection(password);
            this.store = KeyStore.getInstance("BKS");
            this.context = context;
            this.store.load(this.getKeystoreStream(), password);
            this.password = password;
        }
        catch (KeyStoreException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (CertificateException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public byte[] getEntry(String keyAlias) {
        Key key = null;
        try {
            if (this.store.containsAlias(keyAlias)) {
                KeyStore.SecretKeyEntry keyEntry = (KeyStore.SecretKeyEntry)this.store.getEntry(keyAlias, this.passwordProtectionParameter);
                key = keyEntry.getSecretKey();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (UnrecoverableEntryException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (KeyStoreException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return key != null ? key.getEncoded() : null;
    }

    public void addEntry(String keyAlias, byte[] keyBytes) {
        KeyStore.SecretKeyEntry secretEntry = new KeyStore.SecretKeyEntry(new SecretKeySpec(keyBytes, "ECDH"));
        try {
            this.store.setEntry(keyAlias, secretEntry, this.passwordProtectionParameter);
        }
        catch (KeyStoreException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
        }
    }

    public void save() {
        try {
            this.store.store(this.createKeystoreStream(), this.password);
        }
        catch (KeyStoreException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (CertificateException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private InputStream getKeystoreStream() {
        File keystore = new File(this.context.getFilesDir(), DEFAULT_KEYSTORE);
        if (!keystore.exists()) {
            return null;
        }
        try {
            return new FileInputStream(keystore);
        }
        catch (FileNotFoundException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    private FileOutputStream createKeystoreStream() {
        File keystore = new File(this.context.getFilesDir(), DEFAULT_KEYSTORE);
        if (!keystore.exists()) {
            try {
                return this.context.openFileOutput(DEFAULT_KEYSTORE, 0);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

