/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz;

import android.util.Pair;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.android.authorization.AuthzType;
import org.jboss.aerogear.android.impl.authz.AuthzTypes;

public class AuthzConfig {
    private final URL baseURL;
    private final String name;
    private String authzEndpoint = "";
    private String redirectURL = "";
    private String accessTokenEndpoint = "";
    private List<String> scopes = new ArrayList<String>();
    private String clientId = "";
    private String clientSecret = "";
    private String accountId = "";
    private Set<Pair<String, String>> additionalAuthorizationParams = new HashSet<Pair<String, String>>();
    private Set<Pair<String, String>> additionalAccessParams = new HashSet<Pair<String, String>>();
    private AuthzType type = AuthzTypes.OAUTH2;

    public AuthzConfig(URL baseURL, String name) {
        this.baseURL = baseURL;
        this.name = name;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getAuthzEndpoint() {
        return this.authzEndpoint;
    }

    public void setAuthzEndpoint(String authzEndpoint) {
        this.authzEndpoint = authzEndpoint;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
    }

    public List<String> getScopes() {
        return new ArrayList<String>(this.scopes);
    }

    public void setScopes(List<String> scopes) {
        this.scopes = new ArrayList<String>(scopes);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getName() {
        return this.name;
    }

    public AuthzType getType() {
        return this.type;
    }

    public void setType(AuthzType type) {
        this.type = type;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Set<Pair<String, String>> getAdditionalAuthorizationParams() {
        return this.additionalAuthorizationParams;
    }

    public Set<Pair<String, String>> getAdditionalAccessParams() {
        return this.additionalAccessParams;
    }
}

