/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.GsonResponseParser;
import org.jboss.aerogear.android.impl.pipeline.loader.AbstractPipeLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.ReadLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.RemoveLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.SaveLoader;
import org.jboss.aerogear.android.impl.reflection.Scan;
import org.jboss.aerogear.android.pipeline.AbstractActivityCallback;
import org.jboss.aerogear.android.pipeline.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipeline.LoaderPipe;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeType;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;
import org.jboss.aerogear.android.pipeline.support.AbstractFragmentActivityCallback;
import org.jboss.aerogear.android.pipeline.support.AbstractSupportFragmentCallback;

@TargetApi(value=14)
public class LoaderAdapter<T>
implements LoaderPipe<T>,
LoaderManager.LoaderCallbacks<HeaderAndBody> {
    private static final String TAG = LoaderAdapter.class.getSimpleName();
    private final Handler handler;
    private Multimap<String, Integer> idsForNamedPipes;
    private final Context applicationContext;
    private Fragment fragment;
    private Activity activity;
    private final Pipe<T> pipe;
    private final LoaderManager manager;
    private final String name;
    private final RequestBuilder<T> requestBuilder;
    private final ResponseParser<T> responseParser;

    @Deprecated
    public LoaderAdapter(Activity activity, Pipe<T> pipe, Gson gson, String name) {
        this.pipe = pipe;
        this.requestBuilder = new GsonRequestBuilder(gson);
        this.responseParser = new GsonResponseParser(gson);
        this.manager = activity.getLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.activity = activity;
    }

    @Deprecated
    public LoaderAdapter(Fragment fragment, Context applicationContext, Pipe<T> pipe, Gson gson, String name) {
        this.pipe = pipe;
        this.manager = fragment.getLoaderManager();
        this.requestBuilder = new GsonRequestBuilder(gson);
        this.responseParser = new GsonResponseParser(gson);
        this.applicationContext = applicationContext;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.fragment = fragment;
    }

    public LoaderAdapter(Activity activity, Pipe<T> pipe, String name) {
        this.pipe = pipe;
        this.requestBuilder = pipe.getRequestBuilder();
        this.responseParser = pipe.getResponseParser();
        this.manager = activity.getLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.activity = activity;
    }

    public LoaderAdapter(Fragment fragment, Context applicationContext, Pipe<T> pipe, String name) {
        this.pipe = pipe;
        this.manager = fragment.getLoaderManager();
        this.requestBuilder = pipe.getRequestBuilder();
        this.responseParser = pipe.getResponseParser();
        this.applicationContext = applicationContext;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.fragment = fragment;
    }

    @Override
    public PipeType getType() {
        return this.pipe.getType();
    }

    @Override
    public URL getUrl() {
        return this.pipe.getUrl();
    }

    @Override
    public void read(Callback<List<T>> callback) {
        int id2 = Objects.hashCode((Object[])new Object[]{this.name, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", null);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id2, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void readWithFilter(ReadFilter filter, Callback<List<T>> callback) {
        this.read(filter, callback);
    }

    @Override
    public void read(ReadFilter filter, Callback<List<T>> callback) {
        int id2 = Objects.hashCode((Object[])new Object[]{this.name, filter, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", (Serializable)filter);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id2, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void save(T item, Callback<T> callback) {
        int id2 = Objects.hashCode((Object[])new Object[]{this.name, item, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM", (Serializable)this.requestBuilder.getBody(item));
        bundle.putString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.SAVE_ID", Scan.findIdValueIn(item));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.SAVE));
        this.manager.initLoader(id2, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void remove(String toRemoveId, Callback<Void> callback) {
        int id2 = Objects.hashCode((Object[])new Object[]{this.name, toRemoveId, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", (Serializable)((Object)toRemoveId));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.REMOVE));
        this.manager.initLoader(id2, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public PipeHandler<T> getHandler() {
        return this.pipe.getHandler();
    }

    @Override
    public Gson getGson() {
        return this.requestBuilder instanceof GsonRequestBuilder ? ((GsonRequestBuilder)this.requestBuilder).getGson() : null;
    }

    @Override
    public RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public ResponseParser<T> getResponseParser() {
        return this.responseParser;
    }

    @Override
    public Class<T> getKlass() {
        return this.pipe.getKlass();
    }

    public Loader<HeaderAndBody> onCreateLoader(int id2, Bundle bundle) {
        this.idsForNamedPipes.put((Object)this.name, (Object)id2);
        Methods method = (Methods)((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD"));
        Callback callback = (Callback)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK");
        this.verifyCallback(callback);
        AbstractPipeLoader loader = null;
        switch (method) {
            case READ: {
                ReadFilter filter = (ReadFilter)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER");
                loader = new ReadLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), filter, this);
                break;
            }
            case REMOVE: {
                String toRemove = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", "-1");
                loader = new RemoveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), toRemove);
                break;
            }
            case SAVE: {
                byte[] data = bundle.getByteArray("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM");
                String dataId = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.SAVE_ID");
                loader = new SaveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), data, dataId);
            }
        }
        return loader;
    }

    public void onLoadFinished(Loader<HeaderAndBody> loader, HeaderAndBody data) {
        if (!(loader instanceof AbstractPipeLoader)) {
            Log.e((String)TAG, (String)"Adapter is listening to loaders which it doesn't support");
            throw new IllegalStateException("Adapter is listening to loaders which it doesn't support");
        }
        AbstractPipeLoader modernLoader = (AbstractPipeLoader)loader;
        Object object = null;
        if (!modernLoader.hasException() && data != null && data.getBody() != null) {
            object = this.extractObject(data, modernLoader);
        }
        this.handler.post(new CallbackHandler(this, modernLoader, object));
    }

    public void onLoaderReset(Loader<HeaderAndBody> loader) {
        Log.e((String)TAG, (String)loader.toString());
    }

    @Override
    public void reset() {
        for (Integer id2 : this.idsForNamedPipes.get((Object)this.name)) {
            Loader loader = this.manager.getLoader(id2.intValue());
            if (loader == null) continue;
            this.manager.destroyLoader(id2.intValue());
        }
        this.idsForNamedPipes.removeAll((Object)this.name);
    }

    @Override
    public void setLoaderIds(Multimap<String, Integer> idsForNamedPipes) {
        this.idsForNamedPipes = idsForNamedPipes;
    }

    private void fragmentSuccess(Callback typelessCallback, Object data) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onSuccess(data);
        callback.setFragment(null);
    }

    private void fragmentFailure(Callback typelessCallback, Exception exception) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onFailure(exception);
        callback.setFragment(null);
    }

    private void activitySuccess(Callback typelessCallback, Object data) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onSuccess(data);
        callback.setActivity(null);
    }

    private void activityFailure(Callback typelessCallback, Exception exception) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onFailure(exception);
        callback.setActivity(null);
    }

    private Object extractObject(HeaderAndBody data, AbstractPipeLoader<HeaderAndBody> modernLoader) {
        List<T> results = this.responseParser.handleResponse(data, this.getKlass());
        if (results == null || results.size() == 0) {
            return results;
        }
        if (modernLoader instanceof SaveLoader) {
            return results.get(0);
        }
        return results;
    }

    private void verifyCallback(Callback<List<T>> callback) {
        if (callback instanceof AbstractActivityCallback) {
            if (this.activity == null) {
                throw new IllegalStateException("An AbstractActivityCallback was supplied, but there is no Activity.");
            }
        } else if (callback instanceof AbstractFragmentCallback) {
            if (this.fragment == null) {
                throw new IllegalStateException("An AbstractFragmentCallback was supplied, but there is no Fragment.");
            }
        } else {
            if (callback instanceof AbstractFragmentActivityCallback) {
                throw new IllegalStateException("An AbstractFragmentActivityCallback was supplied, but this is the modern Loader.");
            }
            if (callback instanceof AbstractSupportFragmentCallback) {
                throw new IllegalStateException("An AbstractSupportFragmentCallback was supplied, but this is the modern Loader.");
            }
        }
    }

    static class CallbackHandler<T>
    implements Runnable {
        private final LoaderAdapter<T> adapter;
        private final AbstractPipeLoader<T> modernLoader;
        private final Object data;

        public CallbackHandler(LoaderAdapter<T> adapter, AbstractPipeLoader loader, Object data) {
            this.adapter = adapter;
            this.modernLoader = loader;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.modernLoader.hasException()) {
                Exception exception = this.modernLoader.getException();
                Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                    ((LoaderAdapter)this.adapter).fragmentFailure(this.modernLoader.getCallback(), exception);
                } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                    ((LoaderAdapter)this.adapter).activityFailure(this.modernLoader.getCallback(), exception);
                } else {
                    this.modernLoader.getCallback().onFailure(exception);
                }
            } else if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                ((LoaderAdapter)this.adapter).fragmentSuccess(this.modernLoader.getCallback(), this.data);
            } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                ((LoaderAdapter)this.adapter).activitySuccess(this.modernLoader.getCallback(), this.data);
            } else {
                this.modernLoader.getCallback().onSuccess(this.data);
            }
        }
    }

    private static enum Methods {
        READ,
        SAVE,
        REMOVE;

    }
}

