/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.aerogear.android.impl.reflection.FieldNotFoundException;
import org.jboss.aerogear.android.impl.reflection.PropertyNotFoundException;

public class Property {
    private final Class klass;
    private final String fieldName;
    private Class type;
    private Method getMethod;
    private Method setMethod;

    public Class getType() {
        return this.type;
    }

    public Property(Class klass, String fieldName) {
        if (klass == null) {
            throw new IllegalArgumentException("Class could not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Fieldname could not be null");
        }
        this.klass = klass;
        this.fieldName = fieldName;
        this.setPropertyType();
        this.findAccessorMethods();
    }

    private void setPropertyType() {
        try {
            this.type = this.findFieldInClass(this.klass, this.fieldName).getType();
        }
        catch (NoSuchFieldException e) {
            throw new FieldNotFoundException(this.klass, this.fieldName);
        }
    }

    private Field findFieldInClass(Class klass, String fieldName) throws NoSuchFieldException {
        try {
            return klass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superclass = klass.getSuperclass();
            if (superclass != null) {
                return this.findFieldInClass(superclass, fieldName);
            }
            throw new NoSuchFieldException();
        }
    }

    private void findAccessorMethods() {
        try {
            this.getMethod = this.klass.getMethod(this.getMethodName(), new Class[0]);
            this.setMethod = this.klass.getMethod(this.setMethodName(), this.type);
        }
        catch (Exception e) {
            throw new PropertyNotFoundException(this.klass, this.getType(), this.fieldName);
        }
    }

    private String getMethodName() {
        if (this.type == Boolean.TYPE) {
            return "is" + this.capitalize(this.fieldName);
        }
        return "get" + this.capitalize(this.fieldName);
    }

    private String setMethodName() {
        return "set" + this.capitalize(this.fieldName);
    }

    private String capitalize(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public Object getValue(Object instance) {
        try {
            return this.getMethod.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new PropertyNotFoundException(this.klass, this.getType(), this.fieldName);
        }
    }

    public void setValue(Object instance, Object value) {
        try {
            this.setMethod.invoke(instance, value);
        }
        catch (Exception e) {
            throw new PropertyNotFoundException(this.klass, this.getType(), this.fieldName);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

