/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.log.LoggerMessages;
import org.jboss.aerogear.controller.router.Router;

@WebFilter(filterName="aerogear-controller", urlPatterns={"/*"})
public class AeroGear
implements Filter {
    @Inject
    private Router router;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isHttpServletContainer(request, response)) {
            throw LoggerMessages.MESSAGES.mustRunInsideAContainer();
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.router.hasRouteFor(httpServletRequest)) {
            this.router.dispatch(httpServletRequest, httpServletResponse, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isHttpServletContainer(ServletRequest request, ServletResponse response) {
        return !(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse);
    }

    public void destroy() {
    }
}

