/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.log.LoggerMessages;
import org.jboss.aerogear.controller.router.RequestMethod;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteBuilder;
import org.jboss.aerogear.controller.router.RouteBuilderImpl;
import org.jboss.aerogear.controller.router.error.ErrorRoute;

public class Routes {
    private final List<Route> routes = new ArrayList<Route>();

    private Routes(List<RouteBuilder> routeBuilders) {
        for (RouteBuilder routeBuilder : routeBuilders) {
            this.routes.add(routeBuilder.build());
        }
    }

    public static RouteBuilder route() {
        return new RouteBuilderImpl();
    }

    public static Routes from(List<RouteBuilder> routes) {
        return new Routes(routes);
    }

    public String toString() {
        return "Routes{routes=" + this.routes + '}';
    }

    public boolean hasRouteFor(RequestMethod method, String requestURI, Set<String> acceptHeaders) {
        AeroGearLogger.LOGGER.requestedRoute(method, requestURI);
        for (Route route : this.routes) {
            if (!route.matches(method, requestURI, acceptHeaders)) continue;
            return true;
        }
        return false;
    }

    public Route routeFor(RequestMethod method, String requestURI, Set<String> acceptHeaders) {
        for (Route route : this.routes) {
            if (!route.matches(method, requestURI, acceptHeaders)) continue;
            return route;
        }
        throw LoggerMessages.MESSAGES.routeNotFound(method, requestURI, acceptHeaders);
    }

    public Route routeFor(Throwable throwable) {
        for (Route route : this.routes) {
            if (!route.canHandle(throwable)) continue;
            return route;
        }
        return ErrorRoute.DEFAULT.getRoute();
    }
}

