/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import org.jboss.aerogear.controller.router.rest.pagination.Links;

public class WebLinking {
    public static final String PREVIOUS = "previous";
    public static final String NEXT = "next";
    public static final String LINK_HEADER = "Link";
    private Links links;

    public WebLinking(Links links) {
        this.links = links;
    }

    public String getLinkHeaderName() {
        return LINK_HEADER;
    }

    public String getNext() {
        return this.oneLink(this.links.getNext(), NEXT);
    }

    public String getPrevious() {
        return this.oneLink(this.links.getPrevious(), PREVIOUS);
    }

    public String getLinkHeaders() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.oneLink(this.links.getPrevious(), PREVIOUS)).append(",");
        sb.append(this.getNext());
        return sb.toString();
    }

    private String oneLink(String link, String type) {
        return "<" + link + ">; " + "rel=" + "\"" + type + "\"";
    }

    public String toString() {
        return "WebLinking[Link:" + this.getLinkHeaders() + "]";
    }
}

