/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.RequestMethod;
import org.jboss.aerogear.controller.router.RouteBuilder;
import org.jboss.aerogear.controller.router.parameter.Parameter;
import org.jboss.aerogear.controller.router.rest.pagination.Paginated;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;

public class RouteDescriptor
implements RouteBuilder.OnMethods,
RouteBuilder.TargetEndpoint {
    private String path;
    private Method targetMethod;
    private Object[] args;
    private RequestMethod[] methods;
    private Class<?> targetClass;
    private String[] roles;
    private final List<String> consumes = new LinkedList<String>();
    private final List<Parameter<?>> parameters = new LinkedList();
    private MediaType[] produces;
    private Set<Class<? extends Throwable>> throwables;
    private static final FinalizeFilter FINALIZE_FILTER = new FinalizeFilter();

    public RouteDescriptor setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public RouteBuilder.TargetEndpoint on(RequestMethod ... methods) {
        this.methods = methods;
        return this;
    }

    @Override
    public RouteBuilder.OnMethods roles(String ... roles) {
        this.roles = roles;
        return this;
    }

    @Override
    public <T> T to(Class<T> clazz) {
        this.targetClass = clazz;
        try {
            Object o = Enhancer.create(clazz, null, (CallbackFilter)FINALIZE_FILTER, (Callback[])new Callback[]{new MyMethodInterceptor(this), NoOp.INSTANCE});
            return (T)o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public RequestMethod[] getMethods() {
        return this.methods;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        return "RouteDescriptor{path='" + this.path + '\'' + ", targetMethod=" + this.targetMethod + ", args=" + (this.args == null ? null : Arrays.asList(this.args)) + '}';
    }

    public RouteDescriptor setThrowables(Set<Class<? extends Throwable>> throwables) {
        this.throwables = throwables;
        return this;
    }

    public Set<Class<? extends Throwable>> getThrowables() {
        return this.throwables;
    }

    public List<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public RouteBuilder.TargetEndpoint produces(MediaType ... produces) {
        this.produces = produces;
        return this;
    }

    public MediaType[] getProduces() {
        return this.produces;
    }

    @Override
    public RouteBuilder.TargetEndpoint consumes(String ... consumes) {
        this.consumes.addAll(Arrays.asList(consumes));
        return this;
    }

    @Override
    public RouteBuilder.TargetEndpoint consumes(MediaType ... consumes) {
        this.consumes.addAll(this.toStrings(consumes));
        return this;
    }

    private List<String> toStrings(MediaType ... mediaTypes) {
        LinkedList<String> strings = new LinkedList<String>();
        for (MediaType mediaType : mediaTypes) {
            strings.add(mediaType.getType());
        }
        return strings;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void addParameter(Parameter<?> parameter) {
        this.parameters.add(parameter);
    }

    static /* synthetic */ Object[] access$302(RouteDescriptor x0, Object[] x1) {
        x0.args = x1;
        return x1;
    }

    private static class FinalizeFilter
    implements CallbackFilter {
        private static final int OUR_INTERCEPTOR = 0;
        private static final int NO_OP = 1;

        private FinalizeFilter() {
        }

        public int accept(Method method) {
            return method.getName().equals("finalize") ? 1 : 0;
        }
    }

    private static class MyMethodInterceptor
    implements MethodInterceptor {
        private final RouteDescriptor routeDescriptor;

        public MyMethodInterceptor(RouteDescriptor routeDescriptor) {
            this.routeDescriptor = routeDescriptor;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getAnnotation(Paginated.class) != null) {
                Paginated paginated = method.getAnnotation(Paginated.class);
                this.routeDescriptor.parameters.remove(Parameter.param(PaginationInfo.class));
                this.routeDescriptor.addParameter(Parameter.param(paginated.offsetParamName(), String.valueOf(paginated.defaultOffset()), String.class));
                this.routeDescriptor.addParameter(Parameter.param(paginated.limitParamName(), String.valueOf(paginated.defaultLimit()), String.class));
            }
            this.routeDescriptor.targetMethod = method;
            RouteDescriptor.access$302(this.routeDescriptor, args);
            return null;
        }
    }
}

