/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import com.google.common.base.Optional;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationProperties;
import org.jboss.aerogear.controller.router.rest.pagination.RequestPathParser;

public class Links {
    private final String first;
    private final String previous;
    private final String next;
    private final Optional<String> last;

    public Links(RequestPathParser requestPathParser, PaginationProperties paging) {
        this.first = requestPathParser.replace(0, paging.limit());
        this.next = requestPathParser.replace(paging.nextOffset(), paging.limit());
        this.previous = requestPathParser.replace(paging.previousOffset(), paging.limit());
        this.last = paging.total().isPresent() ? Optional.of((Object)requestPathParser.replace((Integer)paging.total().get() - paging.limit(), paging.limit())) : Optional.absent();
    }

    public String getFirst() {
        return this.first;
    }

    public String getPrevious() {
        return this.previous;
    }

    public String getNext() {
        return this.next;
    }

    public Optional<String> getLast() {
        return this.last;
    }

    public String toString() {
        return "Links[first=" + this.first + ", previous=" + this.previous + ",next=" + this.next + ", last=" + this.last + "]";
    }
}

