/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import com.google.common.base.Optional;
import org.jboss.aerogear.controller.log.ExceptionBundle;

public class PaginationProperties {
    private final int offset;
    private final int limit;
    private final Optional<Integer> total;

    public PaginationProperties(int offset, int limit) {
        this(offset, limit, -1);
    }

    public PaginationProperties(int offset, int limit, int total) {
        this.checkValues(offset, limit);
        this.offset = offset;
        this.limit = limit;
        this.total = total == -1 ? Optional.absent() : Optional.of((Object)total);
    }

    private void checkValues(int offset, int limit) {
        if (offset < 0 || limit <= 0) {
            throw ExceptionBundle.MESSAGES.invalidPagingRequest(offset, limit);
        }
    }

    public int offset() {
        return this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public Optional<Integer> total() {
        return this.total;
    }

    public int nextOffset() {
        int total;
        if (this.offset == 0) {
            return this.limit;
        }
        if (this.total.isPresent() && this.offset + this.limit >= (total = ((Integer)this.total.get()).intValue())) {
            return total;
        }
        return this.offset + this.limit;
    }

    public int previousOffset() {
        if (this.isOffsetGreaterThanTotal()) {
            int total = (Integer)this.total.get();
            return total - this.limit;
        }
        int difference = this.offset - this.limit;
        if (difference < 0) {
            return 0;
        }
        return difference;
    }

    public boolean isFirstOffset() {
        return this.offset < this.limit;
    }

    public boolean isLastOffset() {
        if (this.total.isPresent()) {
            int total = (Integer)this.total.get();
            return this.offset + this.limit >= total;
        }
        return false;
    }

    public boolean isOffsetGreaterThanTotal() {
        if (this.total.isPresent()) {
            int total = (Integer)this.total.get();
            return this.offset >= total;
        }
        return false;
    }

    public String toString() {
        return "Params[offset=" + this.offset + ", limit=" + this.limit + ", total=" + this.total + ", nextOffset=" + this.nextOffset() + ", previousOffset=" + this.previousOffset() + "]";
    }
}

