/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.aerogear.crypto.Util;
import org.jboss.aerogear.crypto.password.DefaultPbkdf2;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class AeroGearCrypto {
    public static final String PROVIDER;
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int DERIVED_KEY_LENGTH = 256;
    public static final int ITERATIONS = 20000;
    public static final int MINIMUM_SALT_LENGTH = 16;
    public static final int MINIMUM_ITERATION = 10000;
    public static final int MINIMUM_SECRET_KEY_SIZE = 32;
    public static final int IV_LENGTH = 96;
    public static final int TAG_LENGTH = 128;

    public static Pbkdf2 pbkdf2() {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            return new DefaultPbkdf2(keyFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String string = PROVIDER = Util.isAndroid() ? "SC" : "BC";
        if (Util.isAndroid()) {
            Security.insertProviderAt((Provider)new org.spongycastle.jce.provider.BouncyCastleProvider(), 1);
        } else if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

