/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.jboss.aerogear.crypto.Padding;
import org.jboss.aerogear.crypto.Random;

public class BlockCipher {
    private BlockCipher() {
    }

    public static AEADBlockCipher getInstance() {
        return BlockCipher.getNewCipher(Mode.GCM);
    }

    public static AEADBlockCipher getNewCipher(Mode blockMode) {
        AESEngine aesEngine = new AESEngine();
        switch (blockMode) {
            case GCM: {
                return new GCMBlockCipher((org.bouncycastle.crypto.BlockCipher)aesEngine);
            }
        }
        throw new RuntimeException("Block cipher not found");
    }

    public static byte[] getIV() {
        return new Random().randomBytes();
    }

    public static enum Mode {
        GCM("GCM", Padding.NONE);

        private final Padding padding;
        private String mode;

        private Mode(String mode, Padding padding) {
            this.mode = mode;
            this.padding = padding;
        }

        public String toString() {
            return String.format("%s/%s", new Object[]{this.mode, this.padding});
        }
    }
}

