/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import org.jboss.aerogear.crypto.Algorithm;
import org.jboss.aerogear.crypto.BlockCipher;
import org.jboss.aerogear.crypto.Padding;

public class Util {
    private static final boolean IS_ANDROID;

    public static byte[] checkLength(byte[] data, int size) {
        if (data == null || data.length < size) {
            throw new RuntimeException("Invalid length: " + data.length);
        }
        return data;
    }

    public static int checkSize(int size, int minimumSize) {
        if (size < minimumSize) {
            throw new RuntimeException("Invalid size: " + size);
        }
        return size;
    }

    public static String formatter(Algorithm algorithm, BlockCipher.Mode mode) {
        return String.format("%s/%s", new Object[]{algorithm, mode});
    }

    public static String formatter(BlockCipher.Mode mode, Padding padding) {
        return String.format("%s/%s", new Object[]{mode, padding});
    }

    public static byte[] newBuffer(int length) {
        return new byte[length];
    }

    public static byte[] newByteArray(byte[] data) {
        byte[] buffer = new byte[data.length];
        System.arraycopy(data, 0, buffer, 0, data.length);
        return buffer;
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    static {
        boolean check;
        try {
            Class.forName("android.app.Activity");
            check = true;
        }
        catch (ClassNotFoundException ignore) {
            check = false;
        }
        IS_ANDROID = check;
    }
}

