/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.StreamCipher;

public class CipherInputStream
extends FilterInputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private byte[] buf;
    private byte[] inBuf;
    private int bufOff;
    private int maxBuf;
    private boolean finalized;
    private static final int INPUT_BUF_SIZE = 2048;

    public CipherInputStream(InputStream is, BufferedBlockCipher cipher) {
        super(is);
        this.bufferedBlockCipher = cipher;
        this.buf = new byte[cipher.getOutputSize(2048)];
        this.inBuf = new byte[2048];
    }

    public CipherInputStream(InputStream is, StreamCipher cipher) {
        super(is);
        this.streamCipher = cipher;
        this.buf = new byte[2048];
        this.inBuf = new byte[2048];
    }

    private int nextChunk() throws IOException {
        int available = super.available();
        if (available <= 0) {
            available = 1;
        }
        if ((available = available > this.inBuf.length ? super.read(this.inBuf, 0, this.inBuf.length) : super.read(this.inBuf, 0, available)) < 0) {
            if (this.finalized) {
                return -1;
            }
            try {
                this.maxBuf = this.bufferedBlockCipher != null ? this.bufferedBlockCipher.doFinal(this.buf, 0) : 0;
            }
            catch (Exception e) {
                throw new IOException("error processing stream: " + e.toString());
            }
            this.bufOff = 0;
            this.finalized = true;
            if (this.bufOff == this.maxBuf) {
                return -1;
            }
        } else {
            this.bufOff = 0;
            try {
                if (this.bufferedBlockCipher != null) {
                    this.maxBuf = this.bufferedBlockCipher.processBytes(this.inBuf, 0, available, this.buf, 0);
                } else {
                    this.streamCipher.processBytes(this.inBuf, 0, available, this.buf, 0);
                    this.maxBuf = available;
                }
            }
            catch (Exception e) {
                throw new IOException("error processing stream: " + e.toString());
            }
            if (this.maxBuf == 0) {
                return this.nextChunk();
            }
        }
        return this.maxBuf;
    }

    public int read() throws IOException {
        if (this.bufOff == this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bufOff == this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int available = this.maxBuf - this.bufOff;
        if (len > available) {
            System.arraycopy(this.buf, this.bufOff, b, off, available);
            this.bufOff = this.maxBuf;
            return available;
        }
        System.arraycopy(this.buf, this.bufOff, b, off, len);
        this.bufOff += len;
        return len;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int available = this.maxBuf - this.bufOff;
        if (n > (long)available) {
            this.bufOff = this.maxBuf;
            return available;
        }
        this.bufOff += (int)n;
        return (int)n;
    }

    public int available() throws IOException {
        return this.maxBuf - this.bufOff;
    }

    public void close() throws IOException {
        super.close();
    }

    public boolean markSupported() {
        return false;
    }
}

