/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import org.jboss.aerogear.AeroGearCrypto;

public class Util {
    private static final boolean IS_ANDROID;
    private static final String ANDROID_ACTIVITY_CLASS = "android.app.Activity";

    public static byte[] checkLength(byte[] data, int size) {
        if (data == null) {
            throw new IllegalArgumentException("Data to check the length of are null.");
        }
        if (data.length < size) {
            throw new IllegalArgumentException("Invalid length: " + data.length);
        }
        return data;
    }

    public static int checkSize(int size, int minimumSize) {
        if (size < minimumSize) {
            throw new RuntimeException("Invalid size: " + size);
        }
        return size;
    }

    public static String formatter(AeroGearCrypto.Algorithm algorithm, AeroGearCrypto.Mode mode) {
        return String.format("%s/%s", new Object[]{algorithm, mode});
    }

    public static String formatter(AeroGearCrypto.Mode mode, AeroGearCrypto.Padding padding) {
        return String.format("%s/%s", new Object[]{mode, padding});
    }

    public static byte[] newBuffer(int length) {
        return new byte[length];
    }

    public static byte[] newByteArray(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data you want to copy are backed by null object.");
        }
        byte[] buffer = new byte[data.length];
        System.arraycopy(data, 0, buffer, 0, data.length);
        return buffer;
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    static {
        boolean check;
        try {
            Class.forName(ANDROID_ACTIVITY_CLASS);
            check = true;
        }
        catch (ClassNotFoundException ignore) {
            check = false;
        }
        IS_ANDROID = check;
    }
}

