/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.aerogear.crypto.encoders.Encoder;

public class Hash {
    public static final String DEFAULT_ALGORITHM = "SHA-256";
    private MessageDigest hashDigest;

    public Hash(String algorithm) {
        try {
            this.hashDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hash algorithm not found: " + algorithm);
        }
    }

    public Hash() {
        this(DEFAULT_ALGORITHM);
    }

    public String digest(byte[] message, Encoder encoder) throws NoSuchAlgorithmException {
        return encoder.encode(this.hashDigest.digest(message));
    }

    public String digest(String message, Encoder encoder) throws NoSuchAlgorithmException {
        return this.digest(message.getBytes(), encoder);
    }

    public byte[] digest(byte[] message) throws NoSuchAlgorithmException {
        return this.hashDigest.digest(message);
    }
}

