/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.crypto.RandomUtils;
import org.jboss.aerogear.crypto.encoders.Encoder;

public class Hmac {
    private Mac hmac;

    public Hmac(String algorithm, SecretKey secretKey) {
        try {
            this.hmac = Mac.getInstance(algorithm);
            this.hmac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm not supported: " + algorithm);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid key: " + e.getCause());
        }
    }

    public Hmac(String algorithm, String secret) throws InvalidKeySpecException {
        this(algorithm, AeroGearCrypto.pbkdf2().generateSecretKey(secret));
    }

    public Hmac(String secret) throws InvalidKeySpecException {
        this("HmacSHA256", secret);
    }

    public Hmac(SecretKey secretKey) {
        this("HmacSHA256", secretKey);
    }

    public String digest(Encoder encoder, byte[] message) throws NoSuchAlgorithmException {
        return encoder.encode(this.hmac.doFinal(message));
    }

    public String digest(byte[] message) throws NoSuchAlgorithmException {
        return this.digest(Encoder.BASE64, this.hmac.doFinal(message));
    }

    public String digest() throws NoSuchAlgorithmException {
        return this.digest(Encoder.BASE64, this.hmac.doFinal(RandomUtils.randomBytes()));
    }
}

