/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jboss.aerogear.crypto.encoders.Encoder;

public class RandomUtils {
    private static SecureRandom secureRandom;
    private static final String ALGORITHM = "SHA1PRNG";

    public static byte[] randomBytes() {
        return RandomUtils.randomBytes(16);
    }

    public static byte[] randomBytes(int n) {
        byte[] buffer = new byte[n];
        if (secureRandom == null) {
            try {
                secureRandom = SecureRandom.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        secureRandom.nextBytes(buffer);
        return buffer;
    }

    public static String randomBytes(int n, Encoder encoder) {
        return encoder.encode(RandomUtils.randomBytes(n));
    }

    public SecureRandom getSecureRandom() {
        byte[] buffer = new byte[16];
        secureRandom.nextBytes(buffer);
        return secureRandom;
    }
}

