/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto.keys;

import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.crypto.Util;
import org.jboss.aerogear.crypto.encoders.Encoder;

public class PrivateKey {
    private byte[] secretKey;

    public PrivateKey() {
        try {
            KeyGenerator kGen = KeyGenerator.getInstance(AeroGearCrypto.Algorithm.AES.toString());
            kGen.init(AeroGearCrypto.Algorithm.AES.getKeySize());
            this.secretKey = kGen.generateKey().getEncoded();
            Util.checkLength(this.secretKey, 32);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: ", e);
        }
    }

    public PrivateKey(byte[] keyBytes) {
        Util.checkLength(keyBytes, 32);
        this.secretKey = keyBytes;
    }

    public PrivateKey(String secretKey) {
        this.secretKey = Encoder.HEX.decode(secretKey);
        Util.checkLength(this.secretKey, 32);
    }

    public PrivateKey(String secretKey, Encoder encoder) {
        Util.checkLength(encoder.decode(secretKey), 32);
        this.secretKey = encoder.decode(secretKey);
    }

    public byte[] toBytes() {
        return this.secretKey;
    }

    public String toString() {
        return Encoder.HEX.encode(this.secretKey);
    }
}

