/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.regex.Pattern;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;

final class Iframe {
    private static final Pattern PATH_PATTERN = Pattern.compile(".*/iframe[0-9-.a-z_]*.html");
    private static final long ONE_YEAR = 31536000000L;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        }
    };
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Could not create a new MD5 instance", e);
            }
        }
    };

    private Iframe() {
    }

    public static boolean matches(String path) {
        return path.startsWith("/iframe");
    }

    public static FullHttpResponse response(SockJsConfig config, HttpRequest request) throws Exception {
        QueryStringDecoder qsd = new QueryStringDecoder(request.getUri());
        String path = qsd.path();
        if (!PATH_PATTERN.matcher(path).matches()) {
            return Iframe.createResponse(request, HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((CharSequence)"Not found", (Charset)CharsetUtil.UTF_8));
        }
        if (request.headers().contains(HttpHeaders.Names.IF_NONE_MATCH)) {
            FullHttpResponse response = Iframe.createResponse(request, HttpResponseStatus.NOT_MODIFIED);
            response.headers().set(HttpHeaders.Names.SET_COOKIE, (Object)"JSESSIONID=dummy; path=/");
            return response;
        }
        String content = Iframe.createContent(config.sockJsUrl());
        FullHttpResponse response = Iframe.createResponse(request, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        response.headers().set(HttpHeaders.Names.CACHE_CONTROL, (Object)"max-age=31536000, public");
        response.headers().set(HttpHeaders.Names.EXPIRES, (Object)Iframe.generateExpires());
        String etag = '\"' + Iframe.generateMd5(content) + '\"';
        response.headers().set(HttpHeaders.Names.ETAG, (Object)etag);
        return response;
    }

    private static String generateExpires() {
        return DATE_FORMAT.get().format(new Date(System.currentTimeMillis() + 31536000000L));
    }

    private static FullHttpResponse createResponse(HttpRequest request, HttpResponseStatus status) {
        return new DefaultFullHttpResponse(request.getProtocolVersion(), status);
    }

    private static FullHttpResponse createResponse(HttpRequest request, HttpResponseStatus status, ByteBuf content) {
        return new DefaultFullHttpResponse(request.getProtocolVersion(), status, content);
    }

    private static String createContent(String url) {
        return "<!DOCTYPE html>\n<html>\n<head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n  <script>\n    document.domain = document.domain;\n    _sockjs_onload = function(){SockJS.bootstrap_iframe();};\n  </script>\n  <script src=\"" + url + "\"></script>\n" + "</head>\n" + "<body>\n" + "  <h2>Don't panic!</h2>\n" + "  <p>This is a SockJS hidden iframe. It's used for cross domain magic.</p>\n" + "</body>\n" + "</html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateMd5(String value) throws Exception {
        byte[] digest = MESSAGE_DIGEST.get().digest(value.getBytes(CharsetUtil.UTF_8));
        Formatter formatter = null;
        try {
            formatter = new Formatter();
            for (byte b : digest) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString().toLowerCase();
            return string;
        }
        finally {
            if (formatter != null) {
                formatter.close();
            }
        }
    }
}

