/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.CloseFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.MessageFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.OpenFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

public class SessionHandler
extends ChannelHandlerAdapter
implements SockJsSessionContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SessionHandler.class);
    private final SessionState sessionState;
    private final SockJsSession session;

    public SessionHandler(SessionState sessionState, SockJsSession session) {
        ArgumentUtil.checkNotNull(sessionState, "sessionState");
        this.sessionState = sessionState;
        this.session = session;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.session.setCurrentContext(ctx);
        if (msg instanceof HttpRequest) {
            this.handleSession(ctx);
        } else if (msg instanceof String) {
            this.handleMessage((String)msg);
        } else {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
        }
    }

    private void handleSession(ChannelHandlerContext ctx) {
        if (logger.isDebugEnabled()) {
            logger.debug("handleSession {}", (Object)this.sessionState);
        }
        switch (this.session.getState()) {
            case CONNECTING: {
                logger.debug("State.CONNECTING sending open frame");
                ctx.channel().writeAndFlush((Object)new OpenFrame());
                this.session.setConnectionContext(ctx);
                this.session.onOpen(this);
                this.sessionState.onConnect(this.session, ctx);
                break;
            }
            case OPEN: {
                if (this.sessionState.isInUse(this.session)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Another connection still in open for [{}]", (Object)this.session.sessionId());
                    }
                    ctx.writeAndFlush((Object)new CloseFrame(2010, "Another connection still open"));
                    this.session.setState(SockJsSession.States.INTERRUPTED);
                    break;
                }
                this.session.setInuse();
                this.session.setOpenContext(ctx);
                this.sessionState.onOpen(this.session, ctx);
                break;
            }
            case INTERRUPTED: {
                ctx.writeAndFlush((Object)new CloseFrame(1002, "Connection interrupted"));
                break;
            }
            case CLOSED: {
                ctx.writeAndFlush((Object)new CloseFrame(3000, "Go away!"));
                this.session.resetInuse();
            }
        }
    }

    private void handleMessage(String message) throws Exception {
        this.session.onMessage(message);
    }

    @Override
    public void send(String message) {
        Channel channel = this.sessionState.getSendingContext(this.session).channel();
        if (SessionHandler.isWritable(channel)) {
            channel.writeAndFlush((Object)new MessageFrame(message));
        } else {
            this.session.addMessage(message);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.session.resetInuse();
        ctx.fireChannelInactive();
    }

    private static boolean isWritable(Channel channel) {
        return channel.isActive() && channel.isRegistered();
    }

    @Override
    public void close() {
        this.session.onClose();
        this.sessionState.onClose();
        Channel channel = this.sessionState.getSendingContext(this.session).channel();
        if (SessionHandler.isWritable(channel)) {
            CloseFrame closeFrame = new CloseFrame(3000, "Go away!");
            if (logger.isDebugEnabled()) {
                logger.debug("Writing {}", (Object)closeFrame);
            }
            channel.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event == Events.CLOSE_SESSION) {
            this.session.onClose();
            this.sessionState.onSockJSServerInitiatedClose(this.session);
        } else if (event == Events.HANDLE_SESSION) {
            this.handleSession(ctx);
        }
    }

    @Override
    public ChannelHandlerContext getConnectionContext() {
        return this.session.connectionContext();
    }

    @Override
    public ChannelHandlerContext getCurrentContext() {
        return this.session.currentContext();
    }

    public static enum Events {
        CLOSE_SESSION,
        HANDLE_SESSION;

    }
}

