/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsServiceFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.Greeting;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.Iframe;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.Info;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.PollingSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SendingSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.StreamingSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.WebSocketSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.EventSourceTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.HtmlFileTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.JsonpPollingTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.JsonpSendTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.RawWebSocketTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.WebSocketTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.XhrPollingTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.XhrSendTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.XhrStreamingTransport;

public class SockJsHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SockJsHandler.class);
    private final Map<String, SockJsServiceFactory> factories = new LinkedHashMap<String, SockJsServiceFactory>();
    private static final ConcurrentMap<String, SockJsSession> sessions = new ConcurrentHashMap<String, SockJsSession>();
    private static final PathParams NON_SUPPORTED_PATH = new NonSupportedPath();
    private static final Pattern SERVER_SESSION_PATTERN = Pattern.compile("^/([^/.]+)/([^/.]+)/([^/.]+)");

    public SockJsHandler(SockJsServiceFactory ... factories) {
        for (SockJsServiceFactory factory : factories) {
            this.factories.put(factory.config().prefix(), factory);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String path = new QueryStringDecoder(request.getUri()).path();
        for (SockJsServiceFactory factory : this.factories.values()) {
            if (!path.startsWith(factory.config().prefix())) continue;
            SockJsHandler.handleService(factory, request, ctx);
            return;
        }
        SockJsHandler.writeNotFoundResponse((HttpRequest)request, ctx);
    }

    private static void handleService(SockJsServiceFactory factory, FullHttpRequest request, ChannelHandlerContext ctx) throws Exception {
        String pathWithoutPrefix;
        String path;
        if (logger.isDebugEnabled()) {
            logger.debug("RequestUri : [{}]", (Object)request.getUri());
        }
        if (Greeting.matches(path = new QueryStringDecoder(pathWithoutPrefix = request.getUri().replaceFirst(factory.config().prefix(), "")).path())) {
            SockJsHandler.writeResponse(ctx.channel(), (HttpRequest)request, Greeting.response((HttpRequest)request));
        } else if (Info.matches(path)) {
            SockJsHandler.writeResponse(ctx.channel(), (HttpRequest)request, Info.response(factory.config(), (HttpRequest)request));
        } else if (Iframe.matches(path)) {
            SockJsHandler.writeResponse(ctx.channel(), (HttpRequest)request, Iframe.response(factory.config(), (HttpRequest)request));
        } else if (Transports.Type.WEBSOCKET.path().equals(path)) {
            SockJsHandler.addTransportHandler((ChannelHandler)new RawWebSocketTransport(factory.config(), factory.create()), ctx);
            ctx.fireChannelRead((Object)request.retain());
        } else {
            PathParams sessionPath = SockJsHandler.matches(path);
            if (sessionPath.matches()) {
                SockJsHandler.handleSession(factory, request, ctx, sessionPath);
            } else {
                SockJsHandler.writeNotFoundResponse((HttpRequest)request, ctx);
            }
        }
    }

    private static void handleSession(SockJsServiceFactory factory, FullHttpRequest request, ChannelHandlerContext ctx, PathParams pathParams) throws Exception {
        switch (pathParams.transport()) {
            case XHR: {
                SockJsHandler.addTransportHandler((ChannelHandler)new XhrPollingTransport(factory.config(), request), ctx);
                SockJsHandler.addSessionHandler(new PollingSessionState(sessions), SockJsHandler.getSession(factory, pathParams.sessionId()), ctx);
                break;
            }
            case JSONP: {
                SockJsHandler.addTransportHandler((ChannelHandler)new JsonpPollingTransport(factory.config(), request), ctx);
                SockJsHandler.addSessionHandler(new PollingSessionState(sessions), SockJsHandler.getSession(factory, pathParams.sessionId()), ctx);
                break;
            }
            case XHR_SEND: {
                SockJsHandler.checkSessionExists(pathParams.sessionId(), (HttpRequest)request);
                SockJsHandler.addTransportHandler((ChannelHandler)new XhrSendTransport(factory.config()), ctx);
                SockJsHandler.addSessionHandler(new SendingSessionState(sessions), (SockJsSession)sessions.get(pathParams.sessionId()), ctx);
                break;
            }
            case XHR_STREAMING: {
                SockJsHandler.addTransportHandler((ChannelHandler)new XhrStreamingTransport(factory.config(), (HttpRequest)request), ctx);
                SockJsHandler.addSessionHandler(new StreamingSessionState(sessions), SockJsHandler.getSession(factory, pathParams.sessionId()), ctx);
                break;
            }
            case EVENTSOURCE: {
                SockJsHandler.addTransportHandler((ChannelHandler)new EventSourceTransport(factory.config(), (HttpRequest)request), ctx);
                SockJsHandler.addSessionHandler(new StreamingSessionState(sessions), SockJsHandler.getSession(factory, pathParams.sessionId()), ctx);
                break;
            }
            case HTMLFILE: {
                SockJsHandler.addTransportHandler((ChannelHandler)new HtmlFileTransport(factory.config(), (HttpRequest)request), ctx);
                SockJsHandler.addSessionHandler(new StreamingSessionState(sessions), SockJsHandler.getSession(factory, pathParams.sessionId()), ctx);
                break;
            }
            case JSONP_SEND: {
                SockJsHandler.checkSessionExists(pathParams.sessionId(), (HttpRequest)request);
                SockJsHandler.addTransportHandler((ChannelHandler)new JsonpSendTransport(factory.config()), ctx);
                SockJsHandler.addSessionHandler(new SendingSessionState(sessions), (SockJsSession)sessions.get(pathParams.sessionId()), ctx);
                break;
            }
            case WEBSOCKET: {
                SockJsHandler.addTransportHandler((ChannelHandler)new WebSocketTransport(factory.config()), ctx);
                SockJsHandler.addSessionHandler(new WebSocketSessionState(), new SockJsSession(UUID.randomUUID().toString(), factory.create()), ctx);
            }
        }
        ctx.fireChannelRead((Object)request.retain());
    }

    private static void addTransportHandler(ChannelHandler transportHandler, ChannelHandlerContext ctx) {
        ctx.pipeline().addLast(new ChannelHandler[]{transportHandler});
    }

    private static void addSessionHandler(SessionState sessionState, SockJsSession session, ChannelHandlerContext ctx) {
        ctx.pipeline().addLast(new ChannelHandler[]{new SessionHandler(sessionState, session)});
    }

    private static void checkSessionExists(String sessionId, HttpRequest request) throws SessionNotFoundException {
        if (!sessions.containsKey(sessionId)) {
            throw new SessionNotFoundException(sessionId, request);
        }
    }

    private static SockJsSession getSession(SockJsServiceFactory factory, String sessionId) {
        SockJsSession session = (SockJsSession)sessions.get(sessionId);
        if (session == null) {
            SockJsSession newSession = new SockJsSession(sessionId, factory.create());
            session = sessions.putIfAbsent(sessionId, newSession);
            if (session == null) {
                session = newSession;
            }
            logger.debug("Created new session [{}]", (Object)sessionId);
        } else {
            logger.debug("Using existing session [{}]", (Object)sessionId);
        }
        return session;
    }

    private static void writeNotFoundResponse(HttpRequest request, ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.getProtocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((CharSequence)"Not found", (Charset)CharsetUtil.UTF_8));
        SockJsHandler.writeResponse(ctx.channel(), request, (FullHttpResponse)response);
    }

    private static void writeResponse(Channel channel, HttpRequest request, FullHttpResponse response) {
        response.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)response.content().readableBytes());
        boolean hasKeepAliveHeader = HttpHeaders.equalsIgnoreCase((CharSequence)HttpHeaders.Values.KEEP_ALIVE, (CharSequence)request.headers().get(HttpHeaders.Names.CONNECTION));
        if (!request.getProtocolVersion().isKeepAliveDefault() && hasKeepAliveHeader) {
            response.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.KEEP_ALIVE);
        }
        ChannelFuture wf = channel.writeAndFlush((Object)response);
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            wf.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof SessionNotFoundException) {
            SessionNotFoundException se = (SessionNotFoundException)cause;
            logger.debug("Could not find session [{}]", (Object)se.sessionId());
            SockJsHandler.writeNotFoundResponse(se.httpRequest(), ctx);
        } else {
            logger.error("exception caught:", cause);
            ctx.fireExceptionCaught(cause);
        }
    }

    static PathParams matches(String path) {
        Matcher matcher = SERVER_SESSION_PATTERN.matcher(path);
        if (matcher.find()) {
            String serverId = matcher.group(1);
            String sessionId = matcher.group(2);
            String transport = matcher.group(3);
            return new MatchingSessionPath(serverId, sessionId, transport);
        }
        return NON_SUPPORTED_PATH;
    }

    public static class NonSupportedPath
    implements PathParams {
        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public String serverId() {
            throw new UnsupportedOperationException("serverId is not available in path");
        }

        @Override
        public String sessionId() {
            throw new UnsupportedOperationException("sessionId is not available in path");
        }

        @Override
        public Transports.Type transport() {
            throw new UnsupportedOperationException("transport is not available in path");
        }
    }

    public static class MatchingSessionPath
    implements PathParams {
        private final String serverId;
        private final String sessionId;
        private final Transports.Type transport;

        public MatchingSessionPath(String serverId, String sessionId, String transport) {
            this.serverId = serverId;
            this.sessionId = sessionId;
            this.transport = Transports.Type.valueOf(transport.toUpperCase());
        }

        @Override
        public boolean matches() {
            return true;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public String sessionId() {
            return this.sessionId;
        }

        @Override
        public Transports.Type transport() {
            return this.transport;
        }
    }

    public static interface PathParams {
        public boolean matches();

        public String serverId();

        public String sessionId();

        public Transports.Type transport();
    }

    private static class SessionNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1101611486620901143L;
        private final String sessionId;
        private final HttpRequest request;

        public SessionNotFoundException(String sessionId, HttpRequest request) {
            this.sessionId = sessionId;
            this.request = request;
        }

        public String sessionId() {
            return this.sessionId;
        }

        public HttpRequest httpRequest() {
            return this.request;
        }
    }
}

