/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsService;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;

class SockJsSession {
    private States state = States.CONNECTING;
    private final String sessionId;
    private final SockJsService service;
    private final LinkedList<String> messages = new LinkedList();
    private final AtomicLong timestamp = new AtomicLong();
    private final AtomicBoolean inuse = new AtomicBoolean();
    private ChannelHandlerContext connectionContext;
    private ChannelHandlerContext currentContext;
    private ChannelHandlerContext openContext;

    public SockJsSession(String sessionId, SockJsService service) {
        this.sessionId = sessionId;
        this.service = service;
    }

    public synchronized ChannelHandlerContext connectionContext() {
        return this.connectionContext;
    }

    public synchronized void setConnectionContext(ChannelHandlerContext ctx) {
        this.connectionContext = ctx;
    }

    public synchronized ChannelHandlerContext openContext() {
        return this.openContext;
    }

    public synchronized void setOpenContext(ChannelHandlerContext ctx) {
        this.openContext = ctx;
    }

    public synchronized ChannelHandlerContext currentContext() {
        return this.currentContext;
    }

    public synchronized void setCurrentContext(ChannelHandlerContext ctx) {
        this.currentContext = ctx;
    }

    public synchronized void setState(States state) {
        this.state = state;
    }

    public synchronized States getState() {
        return this.state;
    }

    public boolean inuse() {
        return this.inuse.get();
    }

    public void setInuse() {
        this.inuse.set(true);
    }

    public void resetInuse() {
        this.inuse.set(false);
    }

    public SockJsConfig config() {
        return this.service.config();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public synchronized void onMessage(String message) throws Exception {
        this.service.onMessage(message);
        this.updateTimestamp();
    }

    public synchronized void onOpen(SockJsSessionContext session) {
        this.setState(States.OPEN);
        this.service.onOpen(session);
        this.updateTimestamp();
    }

    public synchronized void onClose() {
        this.setState(States.CLOSED);
        this.service.onClose();
    }

    public synchronized void addMessage(String message) {
        this.messages.add(message);
        this.updateTimestamp();
    }

    public synchronized void clearMessagees() {
        this.messages.clear();
    }

    public synchronized String[] getAllMessages() {
        String[] array = this.messages.toArray(new String[this.messages.size()]);
        this.messages.clear();
        return array;
    }

    public synchronized void addMessages(String[] messages) {
        this.messages.addAll(Arrays.asList(messages));
    }

    private void updateTimestamp() {
        this.timestamp.set(System.currentTimeMillis());
    }

    public long timestamp() {
        return this.timestamp.get();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "[sessionId=" + this.sessionId + ", state=" + (Object)((Object)this.state) + ']';
    }

    static enum States {
        CONNECTING,
        OPEN,
        CLOSED,
        INTERRUPTED;

    }
}

