/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class JsonpPollingTransport
extends ChannelHandlerAdapter {
    private final FullHttpRequest request;
    private final SockJsConfig config;
    private String callback;

    public JsonpPollingTransport(SockJsConfig config, FullHttpRequest request) {
        this.request = request;
        this.request.retain();
        this.config = config;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            QueryStringDecoder qsd = new QueryStringDecoder(this.request.getUri());
            List c = (List)qsd.parameters().get("c");
            if (c == null) {
                JsonpPollingTransport.respond(ctx, this.request.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, "\"callback\" parameter required");
                ctx.fireUserEventTriggered((Object)SessionHandler.Events.CLOSE_SESSION);
                return;
            }
            this.callback = (String)c.get(0);
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            Frame frame = (Frame)msg;
            ByteBuf content = this.wrapWithFunction(frame.content(), ctx);
            frame.release();
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.request.getProtocolVersion(), HttpResponseStatus.OK, content);
            response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)"application/javascript; charset=UTF-8");
            response.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)content.readableBytes());
            response.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.CLOSE);
            Transports.setNoCacheHeaders((HttpResponse)response);
            Transports.setSessionIdCookie((FullHttpResponse)response, this.config, (HttpRequest)this.request);
            ctx.writeAndFlush((Object)response, promise);
        } else {
            ctx.write(ReferenceCountUtil.retain((Object)msg), promise);
        }
    }

    private ByteBuf wrapWithFunction(ByteBuf data, ChannelHandlerContext ctx) {
        ByteBuf content = ctx.alloc().buffer();
        Transports.escapeJson(data, content);
        String function = this.callback + "(\"" + content.toString(CharsetUtil.UTF_8) + "\");\r\n";
        content.release();
        return Unpooled.copiedBuffer((CharSequence)function, (Charset)CharsetUtil.UTF_8);
    }

    private static void respond(ChannelHandlerContext ctx, HttpVersion httpVersion, HttpResponseStatus status, String message) throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, status);
        Transports.writeContent((FullHttpResponse)response, message, "application/javascript; charset=UTF-8");
        Transports.writeResponse(ctx, (HttpResponse)response);
    }
}

