/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;

public class WebSocketHAProxyHandshaker
extends WebSocketServerHandshaker00 {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketHAProxyHandshaker.class);
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Could not create a new MD5 instance", e);
            }
        }
    };
    private static final Pattern BEGINNING_DIGIT = Pattern.compile("[^0-9]");
    private static final Pattern BEGINNING_SPACE = Pattern.compile("[^ ]");
    private String key1;
    private String key2;

    public WebSocketHAProxyHandshaker(String webSocketURL, String subprotocols, int maxFramePayloadLength) {
        super(webSocketURL, subprotocols, maxFramePayloadLength);
    }

    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        if (!HttpHeaders.equalsIgnoreCase((CharSequence)HttpHeaders.Values.UPGRADE, (CharSequence)req.headers().get(HttpHeaders.Names.CONNECTION)) || !HttpHeaders.equalsIgnoreCase((CharSequence)HttpHeaders.Values.WEBSOCKET, (CharSequence)req.headers().get(HttpHeaders.Names.UPGRADE))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean isHixie76 = req.headers().contains(HttpHeaders.Names.SEC_WEBSOCKET_KEY1) && req.headers().contains(HttpHeaders.Names.SEC_WEBSOCKET_KEY2);
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, isHixie76 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        if (headers != null) {
            res.headers().add(headers);
        }
        res.headers().add(HttpHeaders.Names.UPGRADE, (Object)HttpHeaders.Values.WEBSOCKET);
        res.headers().add(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.UPGRADE);
        if (isHixie76) {
            res.headers().add(HttpHeaders.Names.SEC_WEBSOCKET_ORIGIN, (Object)req.headers().get(HttpHeaders.Names.ORIGIN));
            res.headers().add(HttpHeaders.Names.SEC_WEBSOCKET_LOCATION, (Object)this.uri());
            String subprotocols = req.headers().get(HttpHeaders.Names.SEC_WEBSOCKET_PROTOCOL);
            if (subprotocols != null) {
                String selectedSubprotocol = this.selectSubprotocol(subprotocols);
                if (selectedSubprotocol == null) {
                    throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
                }
                res.headers().add(HttpHeaders.Names.SEC_WEBSOCKET_PROTOCOL, (Object)selectedSubprotocol);
            }
            this.key1 = req.headers().get(HttpHeaders.Names.SEC_WEBSOCKET_KEY1);
            this.key2 = req.headers().get(HttpHeaders.Names.SEC_WEBSOCKET_KEY2);
        } else {
            res.headers().add(HttpHeaders.Names.WEBSOCKET_ORIGIN, (Object)req.headers().get(HttpHeaders.Names.ORIGIN));
            res.headers().add(HttpHeaders.Names.WEBSOCKET_LOCATION, (Object)this.uri());
            String protocol = req.headers().get(HttpHeaders.Names.WEBSOCKET_PROTOCOL);
            if (protocol != null) {
                res.headers().add(HttpHeaders.Names.WEBSOCKET_PROTOCOL, (Object)this.selectSubprotocol(protocol));
            }
        }
        return res;
    }

    protected ByteBuf calculateLastKey(ByteBuf content) {
        int a = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(this.key1).replaceAll("")) / (long)BEGINNING_SPACE.matcher(this.key1).replaceAll("").length());
        int b = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(this.key2).replaceAll("")) / (long)BEGINNING_SPACE.matcher(this.key2).replaceAll("").length());
        long c = content.readLong();
        ByteBuf input = Unpooled.buffer((int)16);
        input.writeInt(a);
        input.writeInt(b);
        input.writeLong(c);
        ByteBuf key = Unpooled.buffer().writeBytes(WebSocketHAProxyHandshaker.md5(input.array()));
        input.release();
        return key;
    }

    public ChannelFuture handshake(Channel channel, FullHttpRequest req) {
        FullHttpResponse response = this.newHandshakeResponse(req, null);
        return channel.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ChannelHandlerContext ctx;
                    ChannelPipeline p = future.channel().pipeline();
                    if (p.get(HttpObjectAggregator.class) != null) {
                        p.remove(HttpObjectAggregator.class);
                    }
                    if ((ctx = p.context(HttpRequestDecoder.class)) == null) {
                        ctx = p.context(HttpServerCodec.class);
                        if (ctx == null) {
                            throw new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline");
                        }
                        p.addBefore(ctx.name(), "wsencoder", (ChannelHandler)WebSocketHAProxyHandshaker.this.newWebsocketDecoder());
                        p.replace(ctx.name(), "wsdecoder", (ChannelHandler)WebSocketHAProxyHandshaker.this.newWebSocketEncoder());
                    } else {
                        p.remove(HttpRequestDecoder.class);
                        p.remove(HttpResponseEncoder.class);
                    }
                } else {
                    logger.info("Write failed: ", future.cause());
                }
            }
        });
    }

    public void addWsCodec(ChannelFuture future) {
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ChannelPipeline p = future.channel().pipeline();
                    p.addFirst(new ChannelHandler[]{WebSocketHAProxyHandshaker.this.newWebsocketDecoder()});
                    p.addFirst(new ChannelHandler[]{WebSocketHAProxyHandshaker.this.newWebSocketEncoder()});
                } else {
                    logger.info("Write failed: ", future.cause());
                }
            }
        });
    }

    private static byte[] md5(byte[] data) {
        MessageDigest md = MESSAGE_DIGEST.get();
        return md.digest(data);
    }

    public static boolean isHAProxyReqeust(FullHttpRequest request) {
        String version = request.headers().get(HttpHeaders.Names.SEC_WEBSOCKET_VERSION);
        return version == null && request.content().readableBytes() == 0;
    }
}

