/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import com.fasterxml.jackson.core.JsonParseException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.WebSocketHAProxyHandshaker;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.JsonUtil;

public class WebSocketHAProxyTransport
extends SimpleChannelInboundHandler<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketHAProxyTransport.class);
    private static final AttributeKey<HttpRequest> REQUEST_KEY = AttributeKey.valueOf((String)"ha-request.key");
    private WebSocketServerHandshaker handshaker;
    private final WebSocketHAProxyHandshaker haHandshaker;

    public WebSocketHAProxyTransport(WebSocketHAProxyHandshaker haHandshaker) {
        this.haHandshaker = haHandshaker;
    }

    protected void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            this.handleContent(ctx, (ByteBuf)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
        ctx.fireUserEventTriggered((Object)SessionHandler.Events.HANDLE_SESSION);
    }

    private void handleContent(ChannelHandlerContext ctx, ByteBuf nounce) {
        ByteBuf key = this.haHandshaker.calculateLastKey(nounce);
        ChannelFuture channelFuture = ctx.write((Object)key);
        this.haHandshaker.addWsCodec(channelFuture);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame wsFrame) throws Exception {
        String[] messages;
        if (wsFrame instanceof CloseWebSocketFrame) {
            wsFrame.retain();
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)wsFrame);
            ctx.close();
            return;
        }
        if (wsFrame instanceof PingWebSocketFrame) {
            wsFrame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(wsFrame.content()));
            return;
        }
        if (!(wsFrame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", wsFrame.getClass().getName()));
        }
        for (String message : messages = JsonUtil.decode((TextWebSocketFrame)wsFrame)) {
            ctx.fireChannelRead((Object)message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof JsonParseException) {
            logger.error("Could not parse json", cause);
            ctx.close();
        } else if (cause instanceof WebSocketHandshakeException) {
            HttpRequest request = (HttpRequest)ctx.attr(REQUEST_KEY).get();
            logger.error("Failed with ws handshake for request: " + request, cause);
            ctx.writeAndFlush((Object)Transports.internalServerErrorResponse(request.getProtocolVersion(), cause.getMessage())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }
}

