/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

public class XhrPollingTransport
extends ChannelHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(XhrPollingTransport.class);
    private final SockJsConfig config;
    private final FullHttpRequest request;

    public XhrPollingTransport(SockJsConfig config, FullHttpRequest request) {
        ArgumentUtil.checkNotNull(config, "config");
        ArgumentUtil.checkNotNull(request, "request");
        this.config = config;
        this.request = request;
        this.request.retain();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            Frame frame = (Frame)msg;
            ByteBuf content = Transports.wrapWithLN(frame.content());
            frame.release();
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.request.getProtocolVersion(), HttpResponseStatus.OK, content);
            response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)"application/javascript; charset=UTF-8");
            response.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)content.readableBytes());
            response.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.CLOSE);
            Transports.setDefaultHeaders((FullHttpResponse)response, this.config, (HttpRequest)this.request);
            Transports.writeResponse(ctx, promise, (HttpResponse)response);
        } else {
            ctx.writeAndFlush(ReferenceCountUtil.retain((Object)msg), promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("caught exception : ", cause);
        ctx.fireExceptionCaught(cause);
    }
}

