/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs;

import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

public final class SockJsConfig {
    private final String prefix;
    private final boolean webSocketEnabled;
    private final long webSocketHeartbeatInterval;
    private final Set<String> webSocketProtocols;
    private final boolean cookiesNeeded;
    private final String sockjsUrl;
    private final long sessionTimeout;
    private final long heartbeatInterval;
    private final int maxStreamingBytesSize;
    private final boolean tls;
    private final String keyStore;
    private final String keystorePassword;

    private SockJsConfig(Builder builder) {
        this.prefix = builder.prefix;
        this.webSocketEnabled = builder.webSocketEnabled;
        this.webSocketProtocols = builder.webSocketProtocols;
        this.webSocketHeartbeatInterval = builder.webSocketHeartbeatInterval;
        this.cookiesNeeded = builder.cookiesNeeded;
        this.sockjsUrl = builder.sockJsUrl;
        this.sessionTimeout = builder.sessionTimeout;
        this.heartbeatInterval = builder.heartbeatInterval;
        this.maxStreamingBytesSize = builder.maxStreamingBytesSize;
        this.tls = builder.tls;
        this.keyStore = builder.keyStore;
        this.keystorePassword = builder.keyStorePassword;
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean isWebSocketEnabled() {
        return this.webSocketEnabled;
    }

    public long webSocketHeartbeatInterval() {
        return this.webSocketHeartbeatInterval;
    }

    public Set<String> webSocketProtocol() {
        return this.webSocketProtocols;
    }

    public String webSocketProtocolCSV() {
        if (this.webSocketProtocols.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.webSocketProtocols.iterator();
        if (iterator.hasNext()) {
            sb.append(iterator.next());
            while (iterator.hasNext()) {
                sb.append(',').append(iterator.next());
            }
        }
        return sb.toString();
    }

    public boolean areCookiesNeeded() {
        return this.cookiesNeeded;
    }

    public String sockJsUrl() {
        return this.sockjsUrl;
    }

    public long sessionTimeout() {
        return this.sessionTimeout;
    }

    public long heartbeatInterval() {
        return this.heartbeatInterval;
    }

    public int maxStreamingBytesSize() {
        return this.maxStreamingBytesSize;
    }

    public boolean isTls() {
        return this.tls;
    }

    public String keyStore() {
        return this.keyStore;
    }

    public String keyStorePassword() {
        return this.keystorePassword;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "[prefix=" + this.prefix + ", webSocketEnabled=" + this.webSocketEnabled + ", webSocketProtocols=" + this.webSocketProtocols + ", webSocketHeartbeatInterval=" + this.webSocketHeartbeatInterval + ", cookiesNeeded=" + this.cookiesNeeded + ", sockJsUrl=" + this.sockjsUrl + ", sessionTimeout=" + this.sessionTimeout + ", heartbeatInterval=" + this.heartbeatInterval + ", maxStreamingBytesSize=" + this.maxStreamingBytesSize + ", tls=" + this.tls + ", keyStore=" + this.keyStore + ']';
    }

    public static Builder withPrefix(String prefix) {
        ArgumentUtil.checkNotNullAndNotEmpty(prefix, "prefix");
        return new Builder(prefix);
    }

    public static class Builder {
        private final String prefix;
        private boolean webSocketEnabled = true;
        private long webSocketHeartbeatInterval = -1L;
        private final Set<String> webSocketProtocols = new HashSet<String>();
        private boolean cookiesNeeded;
        private String sockJsUrl = "http://cdn.sockjs.org/sockjs-0.3.4.min.js";
        private long sessionTimeout = 5000L;
        private long heartbeatInterval = 25000L;
        private int maxStreamingBytesSize = 131072;
        private boolean tls;
        private String keyStore;
        private String keyStorePassword;

        public Builder(String prefix) {
            this.prefix = prefix;
        }

        public Builder disableWebSocket() {
            this.webSocketEnabled = false;
            return this;
        }

        public Builder webSocketHeartbeatInterval(long ms) {
            this.webSocketHeartbeatInterval = ms;
            return this;
        }

        public Builder webSocketProtocols(String ... protocols) {
            this.webSocketProtocols.addAll(Arrays.asList(protocols));
            return this;
        }

        public Builder cookiesNeeded() {
            this.cookiesNeeded = true;
            return this;
        }

        public Builder sockJsUrl(String sockJsUrl) {
            this.sockJsUrl = sockJsUrl;
            return this;
        }

        public Builder sessionTimeout(long ms) {
            this.sessionTimeout = ms;
            return this;
        }

        public Builder heartbeatInterval(long ms) {
            this.heartbeatInterval = ms;
            return this;
        }

        public Builder maxStreamingBytesSize(int max) {
            this.maxStreamingBytesSize = max;
            return this;
        }

        public Builder tls(boolean tls) {
            this.tls = tls;
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder keyStorePassword(String password) {
            this.keyStorePassword = password;
            return this;
        }

        public SockJsConfig build() {
            if (this.tls && (this.keyStore == null || this.keyStorePassword == null)) {
                throw new IllegalStateException("keyStore and keyStorePassword must be specified if 'tls' is enabled");
            }
            return new SockJsConfig(this);
        }
    }
}

