/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Random;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

final class Info {
    private static final Random RANDOM = new Random();

    private Info() {
    }

    public static boolean matches(String path) {
        return path.startsWith("/info");
    }

    public static FullHttpResponse response(SockJsConfig config, HttpRequest request) throws Exception {
        FullHttpResponse response = Info.createResponse(request);
        Transports.setNoCacheHeaders((HttpResponse)response);
        Transports.writeContent(response, Info.infoContent(config), "application/json; charset=UTF-8");
        return response;
    }

    private static FullHttpResponse createResponse(HttpRequest request) {
        return new DefaultFullHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
    }

    private static String infoContent(SockJsConfig config) {
        StringBuilder sb = new StringBuilder("{\"websocket\": ").append(config.isWebSocketEnabled());
        sb.append(", \"origins\": [\"*:*\"]");
        sb.append(", \"cookie_needed\": ").append(config.areCookiesNeeded());
        sb.append(", \"entropy\": ").append(RANDOM.nextInt(Integer.MAX_VALUE) + 1);
        sb.append('}');
        return sb.toString();
    }
}

