/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.CloseFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.MessageFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.OpenFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

public class SessionHandler
extends ChannelHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SessionHandler.class);
    private final SessionState sessionState;

    public SessionHandler(SessionState sessionState) {
        ArgumentUtil.checkNotNull(sessionState, "sessionState");
        this.sessionState = sessionState;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            if (logger.isDebugEnabled()) {
                logger.debug("Handle session : {}", (Object)this.sessionState);
            }
            ReferenceCountUtil.release((Object)msg);
            this.handleSession(ctx);
        } else if (msg instanceof String) {
            this.handleMessage((String)msg);
        } else {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
        }
    }

    private void handleSession(ChannelHandlerContext ctx) throws Exception {
        switch (this.sessionState.getState()) {
            case CONNECTING: {
                this.sessionConnecting(ctx);
                break;
            }
            case OPEN: {
                this.sessionOpen(ctx);
                break;
            }
            case INTERRUPTED: {
                this.sessionInterrupted(ctx);
                break;
            }
            case CLOSED: {
                this.sessionClosed(ctx);
            }
        }
    }

    private void sessionConnecting(ChannelHandlerContext ctx) {
        logger.debug("State.CONNECTING sending open frame");
        SessionHandler.writeOpenFrame(ctx);
        this.sessionState.onConnect(ctx, new DefaultSockJsSessionContext());
    }

    private void sessionOpen(ChannelHandlerContext ctx) {
        if (this.sessionState.isInUse()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Another connection still in open for {}", (Object)this.sessionState);
            }
            SessionHandler.writeCloseFrame(ctx, 2010, "Another connection still open");
            this.sessionState.setState(SessionState.State.INTERRUPTED);
        } else {
            this.sessionState.onOpen(ctx);
        }
    }

    private void sessionInterrupted(ChannelHandlerContext ctx) {
        SessionHandler.writeCloseFrame(ctx, 1002, "Connection interrupted");
    }

    private void sessionClosed(ChannelHandlerContext ctx) {
        SessionHandler.writeCloseFrame(ctx, 3000, "Go away!");
        this.sessionState.onClose();
    }

    private void handleMessage(String message) throws Exception {
        this.sessionState.onMessage(message);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.sessionState.resetInuse();
        ctx.fireChannelInactive();
    }

    private static boolean isWritable(Channel channel) {
        return channel.isActive() && channel.isRegistered();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event == Event.CLOSE_SESSION) {
            this.sessionState.onClose();
            this.sessionState.onSockJSServerInitiatedClose();
        } else if (event == Event.HANDLE_SESSION) {
            this.handleSession(ctx);
        }
    }

    private static void writeCloseFrame(ChannelHandlerContext ctx, int code, String message) {
        ctx.channel().writeAndFlush((Object)new CloseFrame(code, message));
    }

    private static void writeOpenFrame(ChannelHandlerContext ctx) {
        ctx.channel().writeAndFlush((Object)new OpenFrame());
    }

    public class DefaultSockJsSessionContext
    implements SockJsSessionContext {
        @Override
        public void send(String message) {
            Channel channel = SessionHandler.this.sessionState.getSendingContext().channel();
            if (SessionHandler.isWritable(channel)) {
                channel.writeAndFlush((Object)new MessageFrame(message));
            } else {
                SessionHandler.this.sessionState.storeMessage(message);
            }
        }

        @Override
        public void close() {
            SessionHandler.this.sessionState.onClose();
            Channel channel = SessionHandler.this.sessionState.getSendingContext().channel();
            if (SessionHandler.isWritable(channel)) {
                CloseFrame closeFrame = new CloseFrame(3000, "Go away!");
                if (logger.isDebugEnabled()) {
                    logger.debug("Writing {}", (Object)closeFrame);
                }
                channel.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        @Override
        public ChannelHandlerContext getContext() {
            return SessionHandler.this.sessionState.getSendingContext();
        }
    }

    public static enum Event {
        CLOSE_SESSION,
        HANDLE_SESSION;

    }
}

