/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol;

import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;

public class CloseFrame
extends DefaultByteBufHolder
implements Frame {
    private final int statusCode;
    private final String statusMsg;

    public CloseFrame(int statusCode, String statusMsg) {
        super(Unpooled.copiedBuffer((CharSequence)("c[" + statusCode + ",\"" + statusMsg + "\"]"), (Charset)CharsetUtil.UTF_8));
        this.statusCode = statusCode;
        this.statusMsg = statusMsg;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String statusMsg() {
        return this.statusMsg;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "[statusCode=" + this.statusCode + ", statusMsg='" + this.statusMsg + "']";
    }

    @Override
    public CloseFrame copy() {
        return new CloseFrame(this.statusCode, this.statusMsg);
    }

    @Override
    public CloseFrame duplicate() {
        return new CloseFrame(this.statusCode, this.statusMsg);
    }

    @Override
    public CloseFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public CloseFrame retain(int increment) {
        super.retain(increment);
        return this;
    }
}

